/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.metamodel.jdt.javabean;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtTypeStrategy;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class JdtJavaBeanTypeStrategy
implements JdtTypeStrategy {
    private IJavaProject project;

    public JdtJavaBeanTypeStrategy(IJavaProject project) {
        this.project = project;
    }

    public IType[] getSuperTypes(IType type) throws JavaModelException {
        ITypeHierarchy hier = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] ifs = hier.getSuperInterfaces(type);
        IType st = hier.getSuperclass(type);
        if (st == null) {
            return ifs;
        }
        IType[] result = new IType[ifs.length + 1];
        System.arraycopy(ifs, 0, result, 0, ifs.length);
        result[ifs.length] = st;
        return result;
    }

    public boolean isAssignable(IType toAssigTo, IType assignable) throws JavaModelException {
        return assignable.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(toAssigTo);
    }

    public boolean isGetter(IMethod method) {
        int flags;
        try {
            flags = method.getFlags();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        String name = method.getElementName();
        return !Flags.isStatic((int)flags) && method.getParameterTypes().length == 0 && (name.startsWith("get") || name.startsWith("is"));
    }

    public String getterToProperty(String elementName) {
        String propName = null;
        if (elementName.startsWith("get")) {
            propName = elementName.substring(3, elementName.length());
        } else if (elementName.startsWith("is")) {
            propName = elementName.substring(2, elementName.length());
        } else {
            return elementName;
        }
        if (propName.length() == 1 || propName.matches("\\p{Upper}\\p{Lower}.*")) {
            propName = StringHelper.firstLower((String)propName);
            return propName;
        }
        if (propName.length() > 1) {
            return propName;
        }
        return elementName;
    }

    public boolean isConstant(IField field) {
        try {
            return field.isEnumConstant() || field.getDeclaringType().isInterface() || Flags.isPublic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags()) && Flags.isStatic((int)field.getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isOperation(IMethod method) {
        if (!this.isGetter(method)) {
            try {
                int flags = method.getFlags();
                if (!Flags.isStatic((int)flags)) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    public String propertyName(IMethod method) {
        return this.getterToProperty(method.getElementName());
    }

    public String getPropertiesInnerType(IMethod method) {
        try {
            String[] arguments;
            String returnType = method.getReturnType();
            if (Signature.getTypeSignatureKind((String)returnType) == 4) {
                String elementType = Signature.getElementType((String)returnType);
                return elementType;
            }
            if (this.isCollectionType(returnType, method) && (arguments = Signature.getTypeArguments((String)returnType)).length == 1) {
                return arguments[0];
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private boolean isCollectionType(String returnType, IMethod method) {
        try {
            String signatureSimpleName = Signature.getTypeErasure((String)returnType);
            String typeName = this.qualifiedName(method, signatureSimpleName);
            if (typeName != null) {
                IType type = this.project.findType(typeName);
                IType collection = this.project.findType("java.util.Collection");
                if (type != null && type.exists()) {
                    return type.newSupertypeHierarchy(null).contains(collection);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String qualifiedName(IMethod method, String signatureSimpleName) {
        try {
            String[][] result = method.getDeclaringType().resolveType(Signature.toString((String)signatureSimpleName));
            if (result != null && result.length > 0) {
                StringBuffer buff = new StringBuffer();
                int i = 0;
                while (i < result[0].length) {
                    String part = result[0][i];
                    buff.append(part);
                    if (i < result[0].length - 1) {
                        buff.append(".");
                    }
                    ++i;
                }
                return buff.toString();
            }
        }
        catch (JavaModelException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    public String propertyName(IField field) {
        return field.getElementName();
    }
}

