/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.utils.IFilter;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderUtils {
    private static final int COPY_BUFFER_SIZE = 524288;
    private static boolean debug = false;
    private static ConfigurationManagementFilter configurationManagementFilter;

    private FolderUtils() {
    }

    public static final void clearFolder(File dirtyFolder) {
        File[] files;
        assert (dirtyFolder != null);
        assert (dirtyFolder.exists());
        assert (dirtyFolder.isDirectory());
        File[] fileArray = files = dirtyFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderUtils.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    public static final boolean compareFolders(File folderSource, File folderTarget) {
        return FolderUtils.compareFolders(folderSource, folderTarget, configurationManagementFilter, FolderUtils.getDefaultFileComparator());
    }

    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter) {
        return FolderUtils.compareFolders(folderSource, folderTarget, filter, FolderUtils.getDefaultFileComparator());
    }

    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        assert (folderSource != null && folderTarget != null);
        assert (folderSource.isDirectory() && folderTarget.isDirectory());
        boolean result = false;
        if (folderSource.equals(folderTarget)) {
            result = true;
        } else {
            result = FolderUtils.recursiveCompareFolders(folderSource, folderTarget, filter, fileComparison);
            if (debug && !result) {
                MoDiscoLogger.logError("folders " + folderSource.getName() + " and " + folderTarget.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        return result;
    }

    public static final boolean compareFiles(File source, File target) {
        return FolderUtils.compareFiles(source, target, FolderUtils.getDefaultFileComparator());
    }

    private static final Comparator<File> getDefaultFileComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File source, File target) {
                boolean result;
                block33: {
                    result = true;
                    if (!source.getName().equals(target.getName())) {
                        result = false;
                    } else {
                        BufferedReader targetReader;
                        block34: {
                            BufferedReader sourceReader = null;
                            targetReader = null;
                            try {
                                sourceReader = new BufferedReader(new FileReader(source));
                                targetReader = new BufferedReader(new FileReader(target));
                                String sourceLine = sourceReader.readLine();
                                String targetLine = targetReader.readLine();
                                while (sourceLine != null && targetLine != null) {
                                    result = result && sourceLine.equals(targetLine);
                                    sourceLine = sourceReader.readLine();
                                    targetLine = targetReader.readLine();
                                }
                                if (sourceLine != null || targetLine != null) {
                                    result = false;
                                    MoDiscoLogger.logError("These files do not have the same number of lines.", (Plugin)CommonModiscoActivator.getDefault());
                                }
                            }
                            catch (FileNotFoundException e) {
                                result = false;
                                if (sourceReader != null) {
                                    try {
                                        sourceReader.close();
                                    }
                                    catch (IOException e2) {
                                        MoDiscoLogger.logError(e2, (Plugin)CommonModiscoActivator.getDefault());
                                    }
                                }
                                if (targetReader != null) {
                                    try {
                                        targetReader.close();
                                    }
                                    catch (IOException e3) {
                                        MoDiscoLogger.logError(e3, (Plugin)CommonModiscoActivator.getDefault());
                                    }
                                }
                                break block33;
                            }
                            catch (IOException e) {
                                try {
                                    result = false;
                                    break block33;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (sourceReader != null) {
                                        try {
                                            sourceReader.close();
                                        }
                                        catch (IOException e4) {
                                            MoDiscoLogger.logError(e4, (Plugin)CommonModiscoActivator.getDefault());
                                        }
                                    }
                                    if (targetReader != null) {
                                        try {
                                            targetReader.close();
                                        }
                                        catch (IOException e5) {
                                            MoDiscoLogger.logError(e5, (Plugin)CommonModiscoActivator.getDefault());
                                        }
                                    }
                                }
                            }
                            if (sourceReader == null) break block34;
                            try {
                                sourceReader.close();
                            }
                            catch (IOException e) {
                                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                            }
                        }
                        if (targetReader != null) {
                            try {
                                targetReader.close();
                            }
                            catch (IOException e) {
                                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                            }
                        }
                    }
                }
                if (result) {
                    return 0;
                }
                return -1;
            }
        };
    }

    public static final boolean compareFiles(File source, File target, Comparator<File> fileComparator) {
        boolean result;
        assert (source.isFile() && target.isFile());
        boolean bl = result = fileComparator.compare(source, target) == 0;
        if (debug && result) {
            MoDiscoLogger.logInfo("Files " + source.getName() + " and " + target.getName() + " are equal.", (Plugin)CommonModiscoActivator.getDefault());
        }
        return result;
    }

    public static final String getFileContent(File source) {
        StringBuilder result;
        block18: {
            result = new StringBuilder();
            BufferedReader sourceReader = null;
            try {
                sourceReader = new BufferedReader(new FileReader(source));
                String sourceLine = sourceReader.readLine();
                while (sourceLine != null) {
                    result.append(sourceLine);
                    result.append("\n");
                    sourceLine = sourceReader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                if (sourceReader != null) {
                    try {
                        sourceReader.close();
                    }
                    catch (IOException e2) {
                        MoDiscoLogger.logError(e2, (Plugin)CommonModiscoActivator.getDefault());
                    }
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (sourceReader != null) {
                        try {
                            sourceReader.close();
                        }
                        catch (IOException e3) {
                            MoDiscoLogger.logError(e3, (Plugin)CommonModiscoActivator.getDefault());
                        }
                    }
                }
            }
            if (sourceReader == null) break block18;
            try {
                sourceReader.close();
            }
            catch (IOException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        return result.toString();
    }

    private static final boolean recursiveCompareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        File[] targetContents;
        if (debug) {
            MoDiscoLogger.logError("comparison of " + folderSource.getName() + " and " + folderTarget.getName(), (Plugin)CommonModiscoActivator.getDefault());
        }
        boolean result = true;
        File[] sourceContents = folderSource.listFiles(filter);
        if (sourceContents.length != (targetContents = folderTarget.listFiles(filter)).length) {
            result = false;
            if (debug) {
                MoDiscoLogger.logError("folders " + folderSource.getName() + " and " + folderTarget.getName() + " do not have the same number of children (" + sourceContents.length + ", " + targetContents.length + ")", (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            File[] fileArray = sourceContents;
            int n = sourceContents.length;
            int n2 = 0;
            while (n2 < n) {
                boolean subResult;
                File sourceContent = fileArray[n2];
                File targetContent = FolderUtils.getCorrespondingTargetContent(sourceContent, targetContents);
                if (targetContent == null) {
                    result = false;
                    if (debug) {
                        MoDiscoLogger.logError("There is no corresponding element in target folder for " + sourceContent.getName(), (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else if (sourceContent.isDirectory()) {
                    subResult = FolderUtils.recursiveCompareFolders(sourceContent, targetContent, filter, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        MoDiscoLogger.logError("folders " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else {
                    subResult = FolderUtils.compareFiles(sourceContent, targetContent, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        MoDiscoLogger.logError("files " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static final File getCorrespondingTargetContent(File sourceContent, File[] targetContents) {
        File targetContent = null;
        File[] fileArray = targetContents;
        int n = targetContents.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (sourceContent.getName().equals(temp.getName())) {
                targetContent = temp;
            }
            ++n2;
        }
        return targetContent;
    }

    public static final void copyDirectory(File srcDir, File destDir) throws IOException {
        FolderUtils.copyDirectory(srcDir, destDir, new IFilter(){

            public boolean filter(Object object) {
                return true;
            }
        });
    }

    public static final void copyDirectory(File srcDir, File destDir, IFilter filter) throws IOException {
        HashMap<File, File> src2dest = new HashMap<File, File>();
        FolderUtils.copyDirectory2(srcDir, destDir, filter, src2dest);
        for (File srcDir2 : src2dest.keySet()) {
            File destDir2 = (File)src2dest.get(srcDir2);
            if (!destDir2.exists()) {
                destDir2.mkdirs();
            }
            File[] fileArray = srcDir2.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dest;
                File src = fileArray[n2];
                if (!src.isDirectory() && filter.filter(dest = new File(String.valueOf(destDir2.getPath()) + File.separator + src.getName()))) {
                    FolderUtils.copyFile(src, dest);
                }
                ++n2;
            }
        }
    }

    private static final void copyDirectory2(File srcDir, File destDir, IFilter filter, Map<File, File> src2dest) throws IOException {
        src2dest.put(srcDir, destDir);
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dest;
            File src = fileArray[n2];
            if (src.isDirectory() && filter.filter(dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName()))) {
                FolderUtils.copyDirectory2(src, dest, filter, src2dest);
            }
            ++n2;
        }
    }

    public static void copyFolderFromBundle(String sourcePath, Plugin sourcePlugin, String destinationPath, IProject project) throws IOException, CoreException {
        FolderUtils.copyFolderFromBundle(sourcePath, sourcePlugin.getBundle(), destinationPath, project);
    }

    public static void copyFolderFromBundle(String sourcePath, Bundle sourceBundle, String destinationPath, IProject project) throws IOException, CoreException {
        Enumeration e = sourceBundle.getEntryPaths(sourcePath);
        if (e == null) {
            try {
                InputStream source = sourceBundle.getEntry(sourcePath).openStream();
                IFile javaFile = project.getFile(destinationPath);
                if (javaFile.exists()) {
                    javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e1) {
                MoDiscoLogger.logError(e1, (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            String subDestinationPath = "/";
            if (!destinationPath.equals("/")) {
                IFolder folder = project.getFolder(destinationPath);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logError(e1, (Plugin)CommonModiscoActivator.getDefault());
                    }
                }
                subDestinationPath = folder.getProjectRelativePath().toString();
            }
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (object instanceof String) {
                    String subpath = (String)object;
                    if (subpath.matches(".*/\\.svn/")) continue;
                    String dest = String.valueOf(subDestinationPath) + subpath.substring(sourcePath.length() - 1);
                    FolderUtils.copyFolderFromBundle(subpath, sourceBundle, dest, project);
                    continue;
                }
                throw new RuntimeException("Unexpected element type");
            }
        }
    }

    public static final boolean copyFile(File source, File destination) {
        boolean result = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbRead;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbRead = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbRead);
                }
                result = true;
            }
            catch (FileNotFoundException f) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            }
            catch (IOException e) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e2) {
                    result = false;
                }
            }
        }
        finally {
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FolderUtils.clearFolder(directory);
        if (directory.list().length == 0 && !directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FolderUtils.createFolder((IFolder)folder.getParent());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static final void writeFileContent(File source, String newContent) throws IOException {
        FileWriter fw = new FileWriter(source, false);
        fw.write(newContent);
        fw.close();
    }

    private static class ConfigurationManagementFilter
    implements FilenameFilter {
        private static final String FILTER_NAME = "CVS";

        private ConfigurationManagementFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            if (!name.equals(FILTER_NAME)) {
                result = true;
            }
            return result;
        }
    }
}

