/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorClass;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.types.AbstractInheritance;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class ReflectiveInheritance
extends AbstractExecutorClass {
    private @NonNull InheritanceFragment @Nullable [] fragments = null;
    private int @Nullable [] indexes = null;
    private Set<@NonNull ReflectiveInheritance> knownSubInheritances = null;

    protected static int computeFlags(@NonNull Class asClass) {
        TypeId typeId;
        int flags = 0;
        if (asClass instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)asClass;
            if (collectionType.isOrdered()) {
                flags |= 1;
            }
            if (collectionType.isUnique()) {
                flags |= 2;
            }
        }
        if ((typeId = asClass.getTypeId()) == TypeId.OCL_ANY) {
            flags |= 4;
        } else if (typeId == TypeId.OCL_VOID) {
            flags |= 8;
        } else if (typeId == TypeId.OCL_INVALID) {
            flags |= 0x10;
        }
        if (asClass.isIsAbstract()) {
            flags |= 0x20;
        }
        return flags;
    }

    public ReflectiveInheritance(@NonNull String name, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, flags);
    }

    public void addSubInheritance(@NonNull ReflectiveInheritance subInheritance) {
        if (this.knownSubInheritances == null) {
            this.knownSubInheritances = new HashSet<ReflectiveInheritance>();
        }
        this.knownSubInheritances.add(subInheritance);
    }

    protected abstract @NonNull AbstractFragment createFragment(@NonNull CompleteInheritance var1);

    @Override
    public @NonNull EObject createInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Object createInstance(@NonNull String value) {
        throw new UnsupportedOperationException();
    }

    public boolean gatherUninstalledInheritances(@NonNull List<@NonNull ReflectiveInheritance> inheritances) {
        boolean gotOne = false;
        if (!inheritances.contains(this)) {
            inheritances.add(this);
            if (this.fragments == null) {
                for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
                    if (completeInheritance instanceof ReflectiveInheritance) {
                        if (!((ReflectiveInheritance)completeInheritance).gatherUninstalledInheritances(inheritances)) continue;
                        gotOne = true;
                        continue;
                    }
                    gotOne = true;
                }
            } else {
                gotOne = true;
            }
        }
        return gotOne;
    }

    public final  @NonNull AbstractInheritance.FragmentIterable getAllProperSuperFragments() {
        if (this.fragments == null) {
            this.initialize();
        }
        @NonNull InheritanceFragment[] fragments2 = ClassUtil.nonNullState(this.fragments);
        return new AbstractInheritance.FragmentIterable(fragments2, 0, fragments2.length - 1);
    }

    public final  @NonNull AbstractInheritance.FragmentIterable getAllSuperFragments() {
        if (this.fragments == null) {
            this.initialize();
        }
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments));
    }

    @Override
    public final int getDepth() {
        if (this.indexes == null) {
            this.initialize();
        }
        int @Nullable [] indexes2 = this.indexes;
        assert (indexes2 != null);
        return indexes2.length - 2;
    }

    @Override
    public InheritanceFragment getFragment(int fragmentNumber) {
        if (this.fragments == null && this.isOclAny()) {
            this.installOclAny();
        }
        assert (this.fragments != null);
        return this.fragments[fragmentNumber];
    }

    @Override
    public @NonNull Iterable<@NonNull InheritanceFragment> getFragments() {
        @NonNull InheritanceFragment[] fragments2 = this.fragments;
        if (fragments2 == null) {
            this.initialize();
            fragments2 = this.fragments;
            assert (fragments2 != null);
        }
        return new AbstractInheritance.FragmentIterable(fragments2);
    }

    @Override
    public int getIndex(int fragmentNumber) {
        int @Nullable [] indexes2 = this.indexes;
        assert (indexes2 != null);
        return indexes2[fragmentNumber];
    }

    @Override
    public int getIndexes() {
        int @Nullable [] indexes2 = this.indexes;
        assert (indexes2 != null);
        return indexes2.length;
    }

    protected abstract @NonNull Iterable<@NonNull ? extends CompleteInheritance> getInitialSuperInheritances();

    @Override
    public @NonNull InheritanceFragment getSelfFragment() {
        if (this.indexes == null) {
            this.initialize();
        }
        @NonNull InheritanceFragment @Nullable [] fragments2 = this.fragments;
        assert (fragments2 != null);
        InheritanceFragment fragment = this.getFragment(fragments2.length - 1);
        if (fragment == null) {
            throw new IllegalStateException("No self fragment");
        }
        return fragment;
    }

    public final  @NonNull AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        int @Nullable [] indexes2 = this.indexes;
        assert (indexes2 != null);
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments), indexes2[depth], indexes2[depth + 1]);
    }

    protected synchronized void initialize() {
        block3: {
            Boolean gotOne;
            ArrayList<@NonNull ReflectiveInheritance> uninstalledInheritances = new ArrayList<ReflectiveInheritance>();
            this.gatherUninstalledInheritances(uninstalledInheritances);
            ArrayList<@NonNull ReflectiveInheritance> debugOldUninstalledInheritances = new ArrayList<ReflectiveInheritance>(uninstalledInheritances);
            do {
                gotOne = false;
                ListIterator<@NonNull E> it = uninstalledInheritances.listIterator();
                while (it.hasNext()) {
                    @NonNull ReflectiveInheritance uninstalledInheritance = (ReflectiveInheritance)it.next();
                    if (!uninstalledInheritance.isInstallable()) continue;
                    uninstalledInheritance.install();
                    it.remove();
                    gotOne = true;
                }
                if (uninstalledInheritances.isEmpty()) break block3;
            } while (gotOne.booleanValue());
            ArrayList<@NonNull ReflectiveInheritance> debugNewUninstalledInheritances = new ArrayList<ReflectiveInheritance>();
            this.gatherUninstalledInheritances(debugNewUninstalledInheritances);
            StringBuilder s = new StringBuilder();
            s.append("Inheritance loop for ");
            ListIterator it = uninstalledInheritances.listIterator();
            while (it.hasNext()) {
                ReflectiveInheritance uninstalledInheritance = (ReflectiveInheritance)it.next();
                if (uninstalledInheritance.isInstallable()) continue;
                s.append("\n  ");
                s.append(uninstalledInheritance);
            }
            throw new IllegalStateException(s.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean install() {
        if (this.fragments != null) {
            return true;
        }
        if (this.isOclAny()) {
            this.installOclAny();
        } else {
            void var2_7;
            ArrayList<@NonNull ArrayList<@NonNull E>> all = new ArrayList();
            for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
                int n = 0;
                int i = 0;
                while (i < completeInheritance.getIndexes() - 1) {
                    ArrayList<CompleteInheritance> some;
                    ArrayList<CompleteInheritance> arrayList = some = i < all.size() ? (ArrayList<CompleteInheritance>)all.get(i) : null;
                    if (some == null) {
                        some = new ArrayList<CompleteInheritance>();
                        all.add(some);
                    }
                    int jMax = completeInheritance.getIndex(i + 1);
                    while (n < jMax) {
                        InheritanceFragment fragment = completeInheritance.getFragment(n);
                        CompleteInheritance baseInheritance = fragment.getBaseInheritance();
                        if (!some.contains(baseInheritance)) {
                            some.add(baseInheritance);
                            if (baseInheritance instanceof ReflectiveInheritance) {
                                ((ReflectiveInheritance)baseInheritance).addSubInheritance(this);
                            }
                        }
                        ++n;
                    }
                    ++i;
                }
            }
            int n = all.size();
            int superInheritances = 0;
            for (List list : all) {
                superInheritances += list.size();
            }
            assert (n > 0);
            this.fragments = new InheritanceFragment[superInheritances + 1];
            @NonNull InheritanceFragment @NonNull [] inheritanceFragmentArray = this.fragments;
            this.indexes = new int[n + 2];
            int @NonNull [] indexes2 = this.indexes;
            int j = 0;
            indexes2[0] = 0;
            int i = 0;
            while (i < n) {
                for (CompleteInheritance some : (List)all.get(i)) {
                    inheritanceFragmentArray[j++] = this.createFragment(some);
                }
                indexes2[i + 1] = j;
                ++i;
            }
            indexes2[n] = j;
            inheritanceFragmentArray[j++] = this.createFragment(this);
            ++var2_7;
            indexes2[++var2_6] = j;
        }
        return true;
    }

    protected final void installOclAny() {
        assert (this.fragments == null);
        this.fragments = new InheritanceFragment[]{this.createFragment(this)};
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.indexes = nArray;
    }

    public boolean isInstallable() {
        if (this.isOclAny()) {
            return true;
        }
        if (this.fragments != null) {
            return true;
        }
        for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
            if (!(completeInheritance instanceof ReflectiveInheritance) || ((ReflectiveInheritance)completeInheritance).isInstalled()) continue;
            return false;
        }
        return true;
    }

    public boolean isInstalled() {
        return this.fragments != null;
    }

    public void removeSubInheritance(@NonNull ReflectiveInheritance subInheritance) {
        if (this.knownSubInheritances != null) {
            this.knownSubInheritances.remove(subInheritance);
        }
    }

    public void uninstall() {
        boolean isNonNull;
        @NonNull InheritanceFragment @Nullable [] fragments2 = this.fragments;
        boolean bl = isNonNull = fragments2 != null;
        if (isNonNull && fragments2 != null) {
            InheritanceFragment[] inheritanceFragmentArray = fragments2;
            int n = fragments2.length;
            int n2 = 0;
            while (n2 < n) {
                InheritanceFragment fragment = inheritanceFragmentArray[n2];
                CompleteInheritance baseInheritance = fragment.getBaseInheritance();
                if (baseInheritance instanceof ReflectiveInheritance) {
                    ((ReflectiveInheritance)baseInheritance).removeSubInheritance(this);
                }
                ++n2;
            }
            this.fragments = null;
            this.indexes = null;
            if (this.knownSubInheritances != null) {
                Set<ReflectiveInheritance> previouslyKnownSubInheritances = this.knownSubInheritances;
                this.knownSubInheritances = null;
                for (ReflectiveInheritance subInheritance : previouslyKnownSubInheritances) {
                    subInheritance.uninstall();
                }
            }
        }
    }
}

