/*******************************************************************************
 * Copyright (c) 2011, 2019 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.pivot.evaluation;

import java.util.regex.Pattern;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.IdResolver;

public interface Evaluator
{
	/** @deprecated evaluators no longer nest. */
	@Deprecated
	@NonNull Evaluator createNestedEvaluator();

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	void dispose();

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	@Nullable Object evaluate(@NonNull OCLExpression body);

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	@NonNull CompleteEnvironment getCompleteEnvironment();

	/**
	 * Return the org.eclipse.emf.common.util.Diagnostic severity to be reported for a non-true
	 * validation resultValue given a severityPreference defined by a StatusCodes value.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue);

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	@NonNull EvaluationEnvironment getEvaluationEnvironment();

	//	/** @deprecated use Executor or EvaluationVisitor. */
	//	@Deprecated
	//	@NonNull Executor getExecutor();

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	@NonNull IdResolver getIdResolver();

	/**
	 * Return the logger handling oclLog() invocations or null for none.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	@Nullable EvaluationLogger getLogger();

	/**
	 * Return the manager of all model instances for use by allInstances() and hidden opposite support.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	@NonNull ModelManager getModelManager();

	/**
	 * Return a cached matcher for a give regular expression.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	@NonNull Pattern getRegexPattern(@NonNull String regex);

	/**
	 * Return the StatusCodes severity with which the validation identified by validationKey is reported.
	 * The validationKey is typically a string such as "ClassName::ConstraintName" for which static literals are
	 * available in an autogenerated *Table file as STR_Classname_c_c_ConstraintName.
	 * <p>
	 * StatusCodes.OK severity suppresses the validation altogether.
	 * <br>
	 * StatusCodes.Warning is returned for any null or unknown key.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	int getSeverity(@Nullable Object validationKey);

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	@NonNull StandardLibrary getStandardLibrary();

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	org.eclipse.ocl.pivot.@NonNull Class getStaticTypeOf(@Nullable Object value);

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	org.eclipse.ocl.pivot.@NonNull Class getStaticTypeOf(@Nullable Object value, @Nullable Object @NonNull ... values);

	/** @deprecated use Executor or EvaluationVisitor. */
	@Deprecated
	org.eclipse.ocl.pivot.@NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values);

	/**
	 * Return true if the evaluation has been canceled.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	boolean isCanceled();

	/**
	 * Request cancelation of the current the evaluation, or reset the request for a new evaluation.
	 * Cancelation occurs by throwing an {@link EvaluationHaltedException} when an expression,
	 * operation or iteration is next invoked.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	void setCanceled(boolean isCanceled);

	/**
	 * Specify the logger to handle oclLog() invocations or null for none.
	 * @deprecated use Executor or EvaluationVisitor.
	 */
	@Deprecated
	void setLogger(@Nullable EvaluationLogger logger);
}
