/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorType;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class EcoreExecutorPackage
extends ExecutorPackage {
    protected final EPackage ePackage;
    private ExecutorStandardLibrary standardLibrary = null;
    private ExecutorType[] types = null;
    private @Nullable List<Package> packages = null;

    public EcoreExecutorPackage(EPackage ePackage) {
        super(ClassUtil.nonNullEMF(ePackage.getName()), ePackage.getNsPrefix(), ePackage.getNsURI(), IdManager.getPackageId(ePackage));
        this.ePackage = ePackage;
    }

    public EcoreExecutorPackage(EPackage ePackage, @NonNull PackageId packageId) {
        super(ClassUtil.nonNullEMF(ePackage.getName()), ePackage.getNsPrefix(), ePackage.getNsURI(), packageId);
        this.ePackage = ePackage;
    }

    @Override
    public final EPackage getEPackage() {
        return this.ePackage;
    }

    @Override
    public EObject getESObject() {
        return this.ePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<Package> getOwnedPackages() {
        List<Package> packages2 = this.packages;
        if (packages2 == null) {
            EcoreExecutorPackage ecoreExecutorPackage = this;
            synchronized (ecoreExecutorPackage) {
                packages2 = this.packages;
                if (packages2 == null) {
                    packages2 = this.packages = new ArrayList<Package>();
                    for (EPackage eSubPackage : this.ePackage.getESubpackages()) {
                        assert (eSubPackage != null);
                        EcoreExecutorPackage subPackage = this.standardLibrary.getPackage(eSubPackage);
                        if (subPackage == null) continue;
                        packages2.add(subPackage);
                    }
                }
            }
        }
        return packages2;
    }

    @Override
    public Package getOwningPackage() {
        EPackage eSuperPackage = this.ePackage.getESuperPackage();
        if (eSuperPackage == null) {
            return null;
        }
        return this.standardLibrary.getPackage(eSuperPackage);
    }

    @Override
    public @NonNull List<Class> getOwnedClasses() {
        if (this.types != null) {
            return Lists.newArrayList((Object[])this.types);
        }
        return Collections.emptyList();
    }

    @Override
    public @Nullable ExecutorType getOwnedClass(String typeName) {
        int index = Arrays.binarySearch(this.types, new ExecutorPackage.StringNameable(typeName), NameUtil.NameableComparator.INSTANCE);
        if (index >= 0) {
            return this.types[index];
        }
        ExecutorType[] executorTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutorType type = executorTypeArray[n2];
            if (type.getName().equals(typeName)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public void init(@Nullable ExecutorStandardLibrary standardLibrary, @NonNull ExecutorType @NonNull [] types) {
        assert (this.standardLibrary == null);
        assert (this.types == null);
        this.standardLibrary = standardLibrary;
        this.types = types;
        if (standardLibrary != null) {
            standardLibrary.addPackage(this, null);
        }
    }
}

