/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;

public class DomainProperties {
    protected final @NonNull CompleteInheritance inheritance;
    protected final @NonNull Map<String, Property> name2property = new HashMap<String, Property>();

    public DomainProperties(@NonNull CompleteInheritance inheritance) {
        this.inheritance = inheritance;
        InheritanceFragment selfFragment = inheritance.getSelfFragment();
        for (Property property : selfFragment.getLocalProperties()) {
            this.name2property.put(property.getName(), property);
        }
    }

    public @NonNull Iterable<? extends Property> getAllProperties(final @Nullable FeatureFilter featureFilter) {
        @NonNull Collection<Property> values = this.name2property.values();
        if (featureFilter == null) {
            return values;
        }
        @NonNull Iterable subItOps = Iterables.filter(values, (Predicate)new Predicate<Property>(){

            public boolean apply(Property domainProperty) {
                return domainProperty != null && featureFilter.accept(domainProperty);
            }
        });
        return subItOps;
    }

    public @Nullable Property getMemberProperty(@NonNull String name) {
        return this.name2property.get(name);
    }
}

