/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorClass;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class JavaType
extends AbstractExecutorClass {
    protected final @NonNull java.lang.Class<?> javaClass;

    public JavaType(@NonNull java.lang.Class<?> javaClass) {
        super(ClassUtil.nonNullState(javaClass.getName()), 0);
        this.javaClass = javaClass;
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type thatType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (this == type) {
            return this;
        }
        if (!(type instanceof JavaType)) {
            return idResolver.getStandardLibrary().getOclAnyType();
        }
        java.lang.Class<?> commonClass = JavaType.getCommonClass1(this.javaClass, ((JavaType)type).javaClass);
        if (commonClass != null) {
            return idResolver.getJavaType(commonClass);
        }
        return idResolver.getStandardLibrary().getOclAnyType();
    }

    private static @Nullable java.lang.Class<?> getCommonClass1(@NonNull java.lang.Class<?> thisClass, @NonNull java.lang.Class<?> thatClass) {
        java.lang.Class<?> commonClass = JavaType.getCommonClass2(thisClass, thatClass);
        if (commonClass != null) {
            return commonClass;
        }
        java.lang.Class<?> superclass = thisClass.getSuperclass();
        if (superclass != null && (commonClass = JavaType.getCommonClass1(superclass, thatClass)) != null) {
            return commonClass;
        }
        java.lang.Class<?>[] classArray = thisClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.Class<?> superInterface = classArray[n2];
            if (superInterface != null && (commonClass = JavaType.getCommonClass1(superInterface, thatClass)) != null) {
                return commonClass;
            }
            ++n2;
        }
        return null;
    }

    private static @Nullable java.lang.Class<?> getCommonClass2(@NonNull java.lang.Class<?> thisClass, @NonNull java.lang.Class<?> thatClass) {
        java.lang.Class<?> commonClass;
        if (thisClass == thatClass) {
            return thisClass;
        }
        java.lang.Class<?> superclass = thatClass.getSuperclass();
        if (superclass != null && (commonClass = JavaType.getCommonClass2(thisClass, superclass)) != null) {
            return commonClass;
        }
        java.lang.Class<?>[] classArray = thatClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.Class<?> commonClass2;
            java.lang.Class<?> superInterface = classArray[n2];
            if (superInterface != null && (commonClass2 = JavaType.getCommonClass2(thisClass, superInterface)) != null) {
                return commonClass2;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull StandardLibrary standardLibrary) {
        if (Comparable.class.isAssignableFrom(this.javaClass)) {
            return standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        }
        return standardLibrary.getOclAnyType().getInheritance(standardLibrary);
    }

    @Override
    public @NonNull TypeId getTypeId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type thatType) {
        return this == thatType;
    }

    @Override
    public @NonNull Operation lookupActualOperation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        CompleteInheritance inheritance = this.getInheritance(standardLibrary);
        return inheritance.lookupActualOperation(standardLibrary, apparentOperation);
    }

    @Override
    public @NonNull LibraryFeature lookupImplementation(@NonNull StandardLibrary standardLibrary, @NonNull Operation apparentOperation) {
        CompleteInheritance inheritance = standardLibrary.getInheritance(standardLibrary.getOclAnyType());
        return inheritance.lookupImplementation(standardLibrary, apparentOperation);
    }

    public String toString() {
        return this.getName();
    }
}

