/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class EcoreOCLEValidator
implements EValidator {
    private static final @NonNull String CONSTRAINTS_KEY = "constraints";
    public static final @NonNull String UNKNOWN_DETAIL = "Unknown ''{0}'' detail for ''{1}''";
    public static final @NonNull String MISSING_DELEGATE = "Missing ''{0}'' delegate for ''{1}''";
    public static final @NonNull String EXTRA_CONSTRAINTS_ANNOTATION_ENTRY = "Extra ''constraints'' annotation entry for {0} ''{1}::{2}''";
    public static final @NonNull String MISSING_CONSTRAINTS_ANNOTATION_ENTRY = "Missing ''constraints'' annotation entry for {0} ''{1}::{2}''";
    public static final @NonNull String MISSING_CONSTRAINTS = "Missing ''{0}::{1}'' annotation for ''{2}''";
    public static final @NonNull String PARSING_ERROR_2 = "Parsing error ''{0}'' for ''{1}'' ''{2}''";
    public static final @NonNull String PARSING_ERROR_1 = "Parsing error ''{0}'' for ''{1}''";
    public static final @NonNull String INCOMPATIBLE_TYPE_2 = "Incompatible type ''{0}'' for {1} ''{2}''";
    @Deprecated
    public static final @NonNull String INCOMPATIBLE_TYPE_1 = "Incompatible type ''{0}'' for ''{1}''";
    public static final @NonNull String NULL_EXPRESSION = "Null expression for ''{0}''";
    public static final @NonNull String NULL_PROPERTY_KEY = "Non-null ''derivation'' or ''initial'' detail allowed for ''{0}''";
    public static final @NonNull String EXTRA_PROPERTY_KEY = "Only ''derivation'' or ''initial'' detail allowed for ''{0}''";
    public static final @NonNull String DOUBLE_PROPERTY_KEY = "Both ''derivation'' and ''initial'' detail for ''{0}''";
    public static final @NonNull String MISSING_PROPERTY_KEY = "Missing ''derivation'' or ''initial'' detail for ''{0}''";
    public static final @NonNull EcoreOCLEValidator INSTANCE = new EcoreOCLEValidator(true);
    public static final @NonNull EcoreOCLEValidator NO_NEW_LINES = new EcoreOCLEValidator(false);
    public static final @NonNull TracingOption VALIDATE_INSTANCE = new TracingOption("org.eclipse.ocl.pivot", "validate/instance");
    public static final @NonNull TracingOption VALIDATE_OPAQUE_ELEMENT = new TracingOption("org.eclipse.ocl.pivot", "validate/opaqueElement");
    protected final boolean mayUseNewLines;

    protected static void gatherTypes(@NonNull Set<Class> allTypes, @NonNull Set<Constraint> allConstraints, @NonNull Class newType) {
        if (allTypes.add(newType)) {
            allConstraints.addAll(newType.getOwnedInvariants());
            for (Class superType : newType.getSuperClasses()) {
                if (superType == null) continue;
                EcoreOCLEValidator.gatherTypes(allTypes, allConstraints, superType);
            }
        }
    }

    public EcoreOCLEValidator(boolean mayUseNewLines) {
        this.mayUseNewLines = mayUseNewLines;
    }

    private <T extends Element> @Nullable T getASOf(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull java.lang.Class<@NonNull T> javaClass, @NonNull ENamedElement eNamedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        T asElement;
        block2: {
            asElement = null;
            try {
                asElement = environmentFactory.getASOf(javaClass, (EObject)eNamedElement);
            }
            catch (ParserException e) {
                if (diagnostics == null) break block2;
                String objectLabel = EObjectValidator.getObjectLabel((EObject)eNamedElement, context);
                String message = StringUtil.bind(PARSING_ERROR_1, e, objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity(environmentFactory), "org.eclipse.emf.ecore.model", 0, message, new Object[]{eNamedElement}));
            }
        }
        return asElement;
    }

    private @NonNull Object getDetailContext(@Nullable LanguageExpression asExpression, @NonNull ENamedElement eNamedElement) {
        EReference eContainmentFeature;
        if (asExpression == null) {
            return eNamedElement;
        }
        EObject esObject = asExpression.getESObject();
        if (esObject != null) {
            return esObject;
        }
        LanguageExpression asElement = asExpression;
        while (asElement instanceof Element) {
            esObject = ((Element)asElement).getESObject();
            if (esObject instanceof EModelElement) break;
            asElement = asElement.eContainer();
        }
        if (esObject == null) {
            return eNamedElement;
        }
        EAnnotation pivotAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eNamedElement);
        if (pivotAnnotation == null) {
            return eNamedElement;
        }
        EMap details = pivotAnnotation.getDetails();
        String detailKey = null;
        Constraint asConstraint = asExpression.getOwningConstraint();
        if (asConstraint != null) {
            eContainmentFeature = asConstraint.eContainmentFeature();
            String constraintName = asConstraint.getName();
            detailKey = eContainmentFeature == PivotPackage.Literals.CLASS__OWNED_INVARIANTS ? (eNamedElement instanceof EOperation ? "body" : constraintName) : (eContainmentFeature == PivotPackage.Literals.NAMESPACE__OWNED_CONSTRAINTS ? constraintName : (eContainmentFeature == PivotPackage.Literals.OPERATION__OWNED_PRECONDITIONS ? (constraintName != null ? "pre_" + constraintName : "pre") : (eContainmentFeature == PivotPackage.Literals.OPERATION__OWNED_POSTCONDITIONS ? (constraintName != null ? "post_" + constraintName : "post") : "body")));
        } else {
            eContainmentFeature = asExpression.eContainmentFeature();
            detailKey = eContainmentFeature == PivotPackage.Literals.PROPERTY__OWNED_EXPRESSION ? (details.containsKey((Object)"derivation") ? "derivation" : "initial") : (eContainmentFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION ? "body" : "body");
        }
        int index = details.indexOfKey((Object)detailKey);
        if (index >= 0) {
            Map.Entry entry = (Map.Entry)details.get(index);
            return entry != null ? entry : pivotAnnotation;
        }
        return eNamedElement;
    }

    private @NonNull EObject getEObjectContext(@NonNull Element asElement, @NonNull EObject eObject) {
        Element asObject = asElement;
        while (asObject instanceof Element) {
            EObject esObject = asObject.getESObject();
            if (esObject != null) {
                return esObject;
            }
            asObject = asObject.eContainer();
        }
        return eObject;
    }

    @Deprecated
    protected @NonNull OCLInternal getOCL(@NonNull Map<Object, Object> context) {
        return (OCLInternal)PivotDiagnostician.getOCL(context, null);
    }

    protected boolean isOCL(List<String> someDelegates) {
        for (String aDelegate : someDelegates) {
            if (!OCLCommon.isDelegateURI((String)aDelegate)) continue;
            return true;
        }
        return false;
    }

    private boolean isStaleStereotypeContent(EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof EPackage) {
                EAnnotation eAnnotation;
                EObject eContainer = eObject.eContainer();
                if (!(eContainer instanceof EAnnotation) || !"http://www.eclipse.org/uml2/2.0.0/UML".equals((eAnnotation = (EAnnotation)eContainer).getSource())) break;
                int index = eAnnotation.getContents().indexOf((Object)eObject);
                return index != 0;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private @Nullable ExpressionInOCL parseSpecification(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull ENamedElement eContext, @NonNull LanguageExpression asSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        block7: {
            block8: {
                expressionInOCL = null;
                try {
                    isParseable = true;
                    if (asSpecification instanceof ExpressionInOCL && (asExpressionInOCL = (ExpressionInOCL)asSpecification).getOwnedBody() == null && asExpressionInOCL.getBody() == null) {
                        isParseable = false;
                    }
                    if (isParseable) {
                        expressionInOCL = environmentFactory.parseSpecification(asSpecification);
                    }
                    break block7;
                }
                catch (ParserException e) {
                    if (diagnostics == null) break block8;
                    objectContext = this.getDetailContext(asSpecification, eContext);
                    data = new Object[]{objectContext};
                    fullMessage = e.getMessage();
                    messages = fullMessage.split("\n");
                    titleDiagnostic = null;
                    var16_15 = messages;
                    var15_16 = messages.length;
                    var14_17 = 0;
                    ** while (var14_17 < var15_16)
                }
lbl-1000:
                // 1 sources

                {
                    message = var16_15[var14_17];
                    severity = PivotUtil.getSeverity(environmentFactory);
                    if (titleDiagnostic == null) {
                        titleDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore.model", 0, fullMessage, data);
                        diagnostics.add((Diagnostic)titleDiagnostic);
                    } else {
                        titleDiagnostic.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, data));
                    }
                    ++var14_17;
                    continue;
                }
            }
            return null;
        }
        return expressionInOCL;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.isStaleStereotypeContent(eObject)) {
            return true;
        }
        assert (context != null);
        boolean allOk = true;
        if (eObject instanceof EPackage) {
            EPackage ePackage = (EPackage)eObject;
            allOk = this.validateEPackage(ePackage, diagnostics, context);
        } else if (eObject instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)eObject;
            allOk = this.validateEClassifier(eClassifier, diagnostics, context);
        } else if (eObject instanceof EOperation) {
            EOperation eOperation = (EOperation)eObject;
            allOk = this.validateEOperation(eOperation, diagnostics, context);
        } else if (eObject instanceof EStructuralFeature) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eObject;
            allOk = this.validateEStructuralFeature(eStructuralFeature, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected boolean validateEClassifier(@NonNull EClassifier eClassifier, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        boolean allOk = true;
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
        if (eAnnotation != null) {
            OCL ocl = PivotDiagnostician.getOCL(context, (EObject)eClassifier);
            EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
            Class asClass = this.getASOf(environmentFactory, Class.class, (ENamedElement)eClassifier, diagnostics, context);
            if (asClass == null) {
                return false;
            }
            PrimitiveType booleanType = environmentFactory.getStandardLibrary().getBooleanType();
            for (Constraint asConstraint : PivotUtil.getOwnedInvariants(asClass)) {
                LanguageExpression asSpecification;
                if (asConstraint.getESObject() instanceof EOperation || (asSpecification = asConstraint.getOwnedSpecification()) == null || this.validateExpressionInOCL(environmentFactory, (ENamedElement)eClassifier, asConstraint, asSpecification, booleanType, diagnostics, context)) continue;
                allOk = false;
            }
            if (!this.validateEClassifierConstraintsAnnotation(environmentFactory, eClassifier, diagnostics, context)) {
                allOk = false;
            }
        }
        return allOk;
    }

    private boolean validateEClassifierConstraintsAnnotation(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull EClassifier eClassifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        Object eContext = eClassifier;
        String constraintsAnnotation = null;
        EAnnotation ecoreAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (ecoreAnnotation != null) {
            eContext = ecoreAnnotation;
            EMap details = ecoreAnnotation.getDetails();
            int index = details.indexOfKey((Object)CONSTRAINTS_KEY);
            if (index >= 0) {
                eContext = details.get(index);
                constraintsAnnotation = (String)details.get((Object)CONSTRAINTS_KEY);
            }
        }
        EAnnotation pivotAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
        int severity = PivotUtil.getSeverity(environmentFactory);
        if (constraintsAnnotation == null) {
            allOk = false;
            if (diagnostics != null) {
                String objectLabel = EObjectValidator.getObjectLabel((EObject)eClassifier, context);
                String message = StringUtil.bind(MISSING_CONSTRAINTS, "http://www.eclipse.org/emf/2002/Ecore", CONSTRAINTS_KEY, objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eClassifier}));
            }
        } else if (pivotAnnotation != null) {
            String message;
            String objectLabel;
            EMap details = pivotAnnotation.getDetails();
            HashSet ecoreConstraintNames = new HashSet(EcoreUtil.getConstraints((EModelElement)eClassifier));
            HashSet oclConstraintNames = new HashSet(details.keySet());
            oclConstraintNames.removeAll(ecoreConstraintNames);
            ecoreConstraintNames.removeAll(details.keySet());
            for (String oclConstraintName : oclConstraintNames) {
                allOk = false;
                if (diagnostics == null) continue;
                objectLabel = NameUtil.qualifiedNameFor(eClassifier);
                message = StringUtil.bind(MISSING_CONSTRAINTS_ANNOTATION_ENTRY, "\u00abinvariant\u00bb", objectLabel, oclConstraintName);
                diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eContext}));
            }
            for (String ecoreConstraintName : ecoreConstraintNames) {
                allOk = false;
                if (diagnostics == null) continue;
                objectLabel = NameUtil.qualifiedNameFor(eClassifier);
                message = StringUtil.bind(EXTRA_CONSTRAINTS_ANNOTATION_ENTRY, "\u00abinvariant\u00bb", objectLabel, ecoreConstraintName);
                diagnostics.add((Diagnostic)new BasicDiagnostic(Math.min(severity, 2), "org.eclipse.emf.ecore.model", 0, message, new Object[]{eContext}));
            }
        }
        return allOk;
    }

    protected boolean validateEPackage(@NonNull EPackage ePackage, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        String message;
        String objectLabel;
        boolean allOk = true;
        boolean needsInvocationDelegates = false;
        boolean needsSettingDelegates = false;
        boolean needsValidationDelegates = false;
        OCL ocl = PivotDiagnostician.getOCL(context, (EObject)ePackage);
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (OCLCommon.getDelegateAnnotation((EModelElement)eClassifier) != null) {
                needsValidationDelegates = true;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EOperation eOperation : eClass.getEOperations()) {
                if (EcoreUtil.isInvariant((EOperation)eOperation) || OCLCommon.getDelegateAnnotation((EModelElement)eOperation) == null) continue;
                needsInvocationDelegates = true;
            }
            for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                if (OCLCommon.getDelegateAnnotation((EModelElement)eStructuralFeature) == null) continue;
                needsSettingDelegates = true;
            }
        }
        boolean hasInvocationDelegates = this.isOCL(EcoreUtil.getInvocationDelegates((EPackage)ePackage));
        boolean hasSettingDelegates = this.isOCL(EcoreUtil.getSettingDelegates((EPackage)ePackage));
        boolean hasValidationDelegates = this.isOCL(EcoreUtil.getValidationDelegates((EPackage)ePackage));
        int severity = PivotUtil.getSeverity(environmentFactory);
        if (needsInvocationDelegates && !hasInvocationDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "invocationDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        if (needsSettingDelegates && !hasSettingDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "settingDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        if (needsValidationDelegates && !hasValidationDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "validationDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        return allOk;
    }

    protected boolean validateEOperation(@NonNull EOperation eOperation, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
        if (eAnnotation == null) {
            return true;
        }
        OCL ocl = PivotDiagnostician.getOCL(context, (EObject)eOperation);
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        NamedElement asElement = this.getASOf(environmentFactory, NamedElement.class, (ENamedElement)eOperation, diagnostics, context);
        if (asElement == null) {
            return false;
        }
        PrimitiveType booleanType = environmentFactory.getStandardLibrary().getBooleanType();
        boolean allOk = true;
        if (asElement instanceof Constraint) {
            Constraint asConstraint = (Constraint)asElement;
            LanguageExpression asSpecification = asConstraint.getOwnedSpecification();
            if (asSpecification != null && !this.validateExpressionInOCL(environmentFactory, (ENamedElement)eOperation, asConstraint, asSpecification, booleanType, diagnostics, context)) {
                allOk = false;
            }
        } else if (asElement instanceof Operation) {
            LanguageExpression asSpecification;
            Operation asOperation = (Operation)asElement;
            LanguageExpression bodyExpression = asOperation.getBodyExpression();
            if (bodyExpression != null && !this.validateExpressionInOCL(environmentFactory, (ENamedElement)eOperation, asOperation, bodyExpression, asOperation.getType(), diagnostics, context)) {
                allOk = false;
            }
            for (Constraint asConstraint : PivotUtil.getOwnedPreconditions(asOperation)) {
                asSpecification = asConstraint.getOwnedSpecification();
                if (asSpecification == null || this.validateExpressionInOCL(environmentFactory, (ENamedElement)eOperation, asConstraint, asSpecification, booleanType, diagnostics, context)) continue;
                allOk = false;
            }
            for (Constraint asConstraint : PivotUtil.getOwnedPostconditions(asOperation)) {
                asSpecification = asConstraint.getOwnedSpecification();
                if (asSpecification == null || this.validateExpressionInOCL(environmentFactory, (ENamedElement)eOperation, asConstraint, asSpecification, booleanType, diagnostics, context)) continue;
                allOk = false;
            }
        }
        return allOk;
    }

    protected boolean validateEStructuralFeature(@NonNull EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        boolean allOk = true;
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eStructuralFeature);
        if (eAnnotation != null) {
            OCL ocl = PivotDiagnostician.getOCL(context, (EObject)eStructuralFeature);
            EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
            EMap details = eAnnotation.getDetails();
            int entries = 0;
            String value = null;
            if (details.containsKey((Object)"derivation")) {
                ++entries;
                value = (String)details.get((Object)"derivation");
            }
            if (details.containsKey((Object)"initial")) {
                ++entries;
                value = (String)details.get((Object)"initial");
            }
            int severity = PivotUtil.getSeverity(environmentFactory);
            if (entries == 0) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(MISSING_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (entries == 2) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(DOUBLE_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (details.size() != 1) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(EXTRA_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(Math.min(severity, 2), "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (value == null) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(NULL_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(Math.min(severity, 2), "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else {
                Property asProperty = this.getASOf(environmentFactory, Property.class, (ENamedElement)eStructuralFeature, diagnostics, context);
                if (asProperty == null) {
                    return false;
                }
                LanguageExpression bodyExpression = asProperty.getOwnedExpression();
                if (bodyExpression != null && !this.validateExpressionInOCL(environmentFactory, (ENamedElement)eStructuralFeature, asProperty, bodyExpression, asProperty.getType(), diagnostics, context)) {
                    allOk = false;
                }
            }
        }
        return allOk;
    }

    @Deprecated
    protected boolean validateExpression(@NonNull MetamodelManagerInternal metamodelManager, @NonNull ENamedElement eNamedElement, @Nullable String expression, @Nullable Type unusedRequiredType, @Nullable String role, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory();
        Element asElement = this.getASOf(environmentFactory, Element.class, eNamedElement, diagnostics, context);
        if (asElement == null) {
            return false;
        }
        StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
        Class booleanType = standardLibrary.getBooleanType();
        Class requiredType = null;
        Constraint asConstraint = null;
        if (asElement instanceof Constraint) {
            asConstraint = (Constraint)asElement;
            asElement = (Element)asElement.eContainer();
        }
        LanguageExpression asSpecification = null;
        if (asElement instanceof Operation && role != null) {
            Operation asOperation = (Operation)asElement;
            if (role.equals("body")) {
                asSpecification = asOperation.getBodyExpression();
            } else if (role.equals("pre")) {
                asConstraint = NameUtil.getNameable(asOperation.getOwnedPreconditions(), "");
                if (asConstraint == null) {
                    asConstraint = NameUtil.getNameable(asOperation.getOwnedPreconditions(), null);
                }
                requiredType = booleanType;
            } else if (role.startsWith("pre_")) {
                asConstraint = NameUtil.getNameable(asOperation.getOwnedPreconditions(), role.substring(4));
                requiredType = booleanType;
            } else if (role.equals("post")) {
                asConstraint = NameUtil.getNameable(asOperation.getOwnedPostconditions(), "");
                if (asConstraint == null) {
                    asConstraint = NameUtil.getNameable(asOperation.getOwnedPostconditions(), null);
                }
                requiredType = booleanType;
            } else if (role.startsWith("post_")) {
                asConstraint = NameUtil.getNameable(asOperation.getOwnedPostconditions(), role.substring(5));
                requiredType = booleanType;
            }
        } else if (asElement instanceof Property) {
            Property asProperty = (Property)asElement;
            asSpecification = asProperty.getOwnedExpression();
        } else if (asElement instanceof Class && role != null && asConstraint == null) {
            Class asClass = (Class)asElement;
            asConstraint = NameUtil.getNameable(asClass.getOwnedInvariants(), role);
            requiredType = booleanType;
        } else if (asElement instanceof Namespace && role != null && asConstraint == null) {
            Namespace asNamespace = (Namespace)asElement;
            asConstraint = NameUtil.getNameable(asNamespace.getOwnedConstraints(), role);
            requiredType = booleanType;
        }
        if (asSpecification == null && asConstraint != null) {
            asSpecification = asConstraint.getOwnedSpecification();
            requiredType = booleanType;
        }
        assert (asSpecification != null);
        ExpressionInOCL expressionInOCL = (ExpressionInOCL)asSpecification;
        assert (expressionInOCL.getOwnedBody() != null);
        Type asExpressionType = expressionInOCL.getType();
        Type asType = requiredType != null ? requiredType : (asElement instanceof TypedElement ? ((TypedElement)asElement).getType() : null);
        assert (asType != null);
        assert (asExpressionType != null);
        if (!environmentFactory.getMetamodelManager().conformsTo(asExpressionType, TemplateParameterSubstitutions.EMPTY, asType, TemplateParameterSubstitutions.EMPTY)) {
            if (diagnostics != null) {
                String objectLabel = EObjectValidator.getObjectLabel((EObject)eNamedElement, context);
                String message = StringUtil.bind(INCOMPATIBLE_TYPE_2, asExpressionType, role != null ? role : "\u00abunknown\u00bb", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity(environmentFactory), "org.eclipse.emf.ecore.model", 0, message, new Object[]{eNamedElement}));
            } else {
                return false;
            }
        }
        Diagnostician nestedDiagnostician = Diagnostician.INSTANCE;
        BasicDiagnostic nestedDiagnostic = nestedDiagnostician.createDefaultDiagnostic((EObject)eNamedElement);
        HashMap<Object, Object> nestedContext = new HashMap<Object, Object>(context);
        nestedContext.remove("org.eclipse.emf.ecore.EObject_NoCircularContainment");
        if (!nestedDiagnostician.validate((EObject)expressionInOCL, (DiagnosticChain)nestedDiagnostic, nestedContext)) {
            if (diagnostics != null) {
                StringBuilder s = new StringBuilder();
                s.append("OCL Validation error for \"" + expressionInOCL.getBody() + "\"");
                for (Diagnostic childDiagnostic : nestedDiagnostic.getChildren()) {
                    if (childDiagnostic == null) continue;
                    s.append("\n\t");
                    s.append(childDiagnostic.getMessage());
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity(environmentFactory), "org.eclipse.emf.ecore.model", 0, s.toString(), new Object[]{eNamedElement}));
            }
            return false;
        }
        return true;
    }

    private boolean validateExpressionInOCL(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull ENamedElement eNamedElement, @NonNull NamedElement asContext, @NonNull LanguageExpression asSpecification, @Nullable Type requiredType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ExpressionInOCL expressionInOCL = this.parseSpecification(environmentFactory, eNamedElement, asSpecification, diagnostics, context);
        if (expressionInOCL == null || expressionInOCL.getOwnedBody() == null) {
            return true;
        }
        boolean allOk = true;
        if (requiredType != null) {
            Type asExpressionType = expressionInOCL.getType();
            assert (asExpressionType != null);
            if (!environmentFactory.getMetamodelManager().conformsTo(asExpressionType, TemplateParameterSubstitutions.EMPTY, requiredType, TemplateParameterSubstitutions.EMPTY)) {
                allOk = false;
                if (diagnostics != null) {
                    String role = PivotUtilInternal.getSpecificationRole(asSpecification);
                    String message = StringUtil.bind(INCOMPATIBLE_TYPE_2, asExpressionType, role, NameUtil.qualifiedNameFor(eNamedElement));
                    diagnostics.add((Diagnostic)new BasicDiagnostic(PivotUtil.getSeverity(environmentFactory), "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.getDetailContext(asSpecification, eNamedElement)}));
                } else {
                    return false;
                }
            }
        }
        Diagnostician nestedDiagnostician = PivotDiagnostician.INSTANCE;
        BasicDiagnostic nestedDiagnostic = nestedDiagnostician.createDefaultDiagnostic(this.getEObjectContext(asSpecification, (EObject)eNamedElement));
        HashMap<Object, Object> nestedContext = new HashMap<Object, Object>(context);
        nestedContext.remove("org.eclipse.emf.ecore.EObject_NoCircularContainment");
        if (!nestedDiagnostician.validate((EObject)expressionInOCL, (DiagnosticChain)nestedDiagnostic, nestedContext)) {
            allOk = false;
            if (diagnostics != null) {
                String role = PivotUtilInternal.getSpecificationRole(asSpecification);
                String contextName = NameUtil.qualifiedNameFor(eNamedElement);
                StringBuilder s = new StringBuilder();
                String body = expressionInOCL.getBody();
                String trimmedBody = body.replace("\\w*", " ").trim();
                s.append("\"" + StringUtil.convertToOCLString(trimmedBody) + "\"");
                for (Diagnostic childDiagnostic : nestedDiagnostic.getChildren()) {
                    if (childDiagnostic == null) continue;
                    s.append("\n\t");
                    s.append(childDiagnostic.getMessage());
                }
                String invalidMessage = StringUtil.bind(PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, role, contextName, s.toString());
                BasicDiagnostic titleDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore.model", 0, invalidMessage, new Object[]{this.getDetailContext(asSpecification, eNamedElement)});
                titleDiagnostic.addAll((Diagnostic)nestedDiagnostic);
                diagnostics.add((Diagnostic)titleDiagnostic);
            }
        }
        return allOk;
    }

    public static class ConstraintEvaluatorWithDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        protected final @NonNull EObject eObject;
        protected final @NonNull DiagnosticChain diagnostics;
        protected final @NonNull EObject diagnosticEObject;
        protected final boolean mayUseNewLines;

        public ConstraintEvaluatorWithDiagnostics(@NonNull ExpressionInOCL expression, @NonNull EObject eObject, @NonNull DiagnosticChain diagnostics, @NonNull EObject diagnosticEObject, boolean mayUseNewLines) {
            super(expression);
            this.diagnosticEObject = diagnosticEObject;
            this.eObject = eObject;
            this.diagnostics = diagnostics;
            this.mayUseNewLines = mayUseNewLines;
        }

        @Override
        protected String getObjectLabel() {
            return NameUtil.qualifiedNameFor(this.eObject);
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString());
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            int severity = this.getConstraintResultSeverity(result);
            String message = this.getConstraintResultMessage(result);
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            String message2 = message;
            if (!this.mayUseNewLines) {
                message2 = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message2.replace("\n", " - "), new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage());
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    public static class ConstraintEvaluatorWithoutDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        public ConstraintEvaluatorWithoutDiagnostics(@NonNull ExpressionInOCL expression) {
            super(expression);
        }

        @Override
        protected String getObjectLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    @Deprecated
    protected static final class WeakOCLReference
    extends WeakReference<OCLInternal> {
        private static int counter = 0;
        protected final @NonNull OCL ocl;
        private int count;

        protected WeakOCLReference(@NonNull OCLInternal ocl) {
            super(ocl);
            this.ocl = ocl;
            this.count = ++counter;
        }

        public void finalize() {
            new Thread("OCL-Finalizer"){

                @Override
                public void run() {
                    ocl.dispose();
                }
            }.start();
        }
    }
}

