/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationUtils;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SMCommon {
    private static boolean firstIf;

    public static int findMax(List<Integer> l) {
        Integer ret = (Integer)IterableExtensions.head(l);
        for (Integer i : l) {
            boolean _greaterThan;
            boolean bl = _greaterThan = i.compareTo(ret) > 0;
            if (!_greaterThan) continue;
            ret = i;
        }
        return ret;
    }

    public static int calculateDepth(Region topRegion, State s) {
        Region _container = s.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)topRegion);
        if (_equals) {
            return 1;
        }
        int _calculateDepth = SMCommon.calculateDepth(topRegion, s.getContainer().getState());
        return 1 + _calculateDepth;
    }

    public static List<Map.Entry<List<State>, Integer>> calculateAcceptingStates(final Region topRegion, State parent, final List<State> acceptingStates) {
        List<State> transitiveSubstates = TransformationUtil.transitiveSubStates(parent);
        final ArrayList<State> retTmp = new ArrayList<State>();
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _contains = acceptingStates.contains(it);
                if (_contains) {
                    retTmp.add(it);
                }
            }
        };
        transitiveSubstates.forEach(_function);
        ArrayList<Map.Entry<List<State>, Integer>> ret = new ArrayList<Map.Entry<List<State>, Integer>>();
        final HashMap map = new HashMap();
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _not;
                int depth = SMCommon.calculateDepth(topRegion, it);
                boolean _containsKey = map.containsKey(depth);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    ArrayList _arrayList = new ArrayList();
                    map.put(depth, _arrayList);
                }
                ((List)map.get(depth)).add(it);
            }
        };
        retTmp.forEach(_function_1);
        int maxDepth = SMCommon.findMax(IterableExtensions.toList(map.keySet()));
        int i = 0;
        while (i <= maxDepth) {
            boolean _containsKey = map.containsKey(i);
            if (_containsKey) {
                boolean _equals;
                int _size = ((List)map.get(i)).size();
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    ArrayList newList = new ArrayList();
                    newList.addAll((Collection)map.get(i));
                    HashMap mapEntry = new HashMap();
                    mapEntry.put(newList, 0);
                    ret.addAll(mapEntry.entrySet());
                } else {
                    HashMap m = new HashMap();
                    List _get = (List)map.get(i);
                    for (State s : _get) {
                        boolean _not;
                        boolean _containsKey_1 = m.containsKey(s.getContainer().getState());
                        boolean bl2 = _not = !_containsKey_1;
                        if (_not) {
                            State _state = s.getContainer().getState();
                            ArrayList _arrayList = new ArrayList();
                            m.put(_state, _arrayList);
                        }
                        ((List)m.get(s.getContainer().getState())).add(s);
                    }
                    Set _entrySet = m.entrySet();
                    for (Map.Entry en : _entrySet) {
                        HashMap mapEntry_1 = new HashMap();
                        ArrayList newList_1 = new ArrayList();
                        newList_1.addAll((Collection)en.getValue());
                        boolean _isOrthogonal = ((State)en.getKey()).isOrthogonal();
                        if (_isOrthogonal) {
                            mapEntry_1.put(newList_1, 1);
                            ret.addAll(mapEntry_1.entrySet());
                            continue;
                        }
                        mapEntry_1.put(newList_1, 0);
                        ret.addAll(mapEntry_1.entrySet());
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public static List<State> getTransitiveParentStates(Vertex s) {
        ArrayList<State> ret = new ArrayList<State>();
        State parent = s.getContainer().getState();
        while (parent != null) {
            ret.add(parent);
            parent = parent.getContainer().getState();
        }
        return ret;
    }

    public static boolean checkSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        final ArrayList substates = new ArrayList();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                Iterables.addAll((Collection)substates, (Iterable)Iterables.filter((Iterable)it.getSubvertices(), State.class));
            }
        };
        parent.getRegions().forEach((Consumer)_function);
        boolean ret = false;
        for (Transition t : transitions) {
            if (ret || !substates.contains(t.getSource())) continue;
            ret = true;
        }
        return ret;
    }

    public static boolean checkTransitiveSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        List<State> substates = TransformationUtil.transitiveSubStates(parent);
        boolean ret = false;
        for (Transition t : transitions) {
            if (ret || !substates.contains(t.getSource())) continue;
            ret = true;
        }
        return ret;
    }

    public static void copyParameters(Operation source, Operation target, boolean isCopyReturn) {
        String name = target.getName();
        OperationUtils.syncOperation((Operation)source, (Operation)target);
        if (!isCopyReturn) {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                }
            };
            Iterable ret = IterableExtensions.filter((Iterable)target.getOwnedParameters(), (Functions.Function1)_function);
            CollectionExtensions.removeAll((Collection)target.getOwnedParameters(), (Iterable)ret);
        }
        EList _stereotypeApplications = target.getStereotypeApplications();
        for (EObject stt : _stereotypeApplications) {
            StereotypeUtil.apply((Element)target, stt.getClass());
        }
        target.setName(name);
    }

    public static boolean initCondElse() {
        firstIf = true;
        return true;
    }

    public static String condElse() {
        if (!firstIf) {
            return "else ";
        }
        firstIf = false;
        return "";
    }

    public static List<Transition> findTrans(Vertex v) {
        UniqueEList ret = new UniqueEList();
        ret.addAll((Collection)v.getOutgoings());
        EList _outgoings = v.getOutgoings();
        for (Transition out : _outgoings) {
            boolean _not;
            Vertex _target = out.getTarget();
            boolean bl = _not = !(_target instanceof State);
            if (!_not) continue;
            ret.addAll(SMCommon.findTrans(out.getTarget()));
        }
        return ret;
    }

    public static List<State> getRootStates(final Region topRegion, List<State> states) {
        ArrayList<State> ret = new ArrayList<State>();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                Region _container = it.getContainer();
                return Objects.equal((Object)_container, (Object)topRegion);
            }
        };
        Iterables.addAll(ret, (Iterable)IterableExtensions.filter(states, (Functions.Function1)_function));
        return ret;
    }

    public static int getRegionNumber(Region topRegion, State child) {
        Region _container = child.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)topRegion);
        if (_equals) {
            return 0;
        }
        return child.getContainer().getState().getRegions().indexOf((Object)child.getContainer());
    }
}

