/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.AutoIndex;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.AutoIndexPerNode;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.ConfigurationProperty;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.CopyAttributeValue;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.deployment.tools.Messages;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.ApplyProfile;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.papyrus.designer.transformation.base.utils.TrafoUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.transformation.extensions.IM2MTrafo;
import org.eclipse.papyrus.designer.transformation.extensions.M2MTrafoExt;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DepCreation {
    private static Map<Object, Integer> map;
    public static final String valueFor = "value for ";
    public static final String CREATE_CONNECTIONS = "createConnections";

    public static Slot createSlot(InstanceSpecification is, InstanceSpecification partIS, Property part) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)part);
        InstanceValue iv = (InstanceValue)slot.createValue(null, null, UMLPackage.eINSTANCE.getInstanceValue());
        iv.setInstance(partIS);
        return slot;
    }

    public static Slot createSlotForConfigProp(InstanceSpecification is, Property attribute) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)attribute);
        Type type = attribute.getType();
        if (type != null) {
            String name = type.getName();
            String qname = type.getQualifiedName();
            if (type instanceof Enumeration) {
                slot.createValue(valueFor + attribute.getName(), type, UMLPackage.eINSTANCE.getInstanceValue());
            } else if (name.equals("Integer") || qname.equals("corba::octet") || qname.equals("corba::long") || qname.equals("corba::unsigned long") || qname.equals("corba::short") || qname.equals("corba::unsigned short")) {
                slot.createValue(valueFor + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralInteger());
            } else if (name.equals("Boolean")) {
                slot.createValue(valueFor + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralBoolean());
            } else {
                slot.createValue(valueFor + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralString());
            }
        }
        return slot;
    }

    public static Slot createStringSlotForConfigProp(InstanceSpecification is, Property attribute) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)attribute);
        Type type = attribute.getType();
        if (type != null) {
            slot.createValue(valueFor + attribute.getName(), type, UMLPackage.eINSTANCE.getLiteralString());
        }
        return slot;
    }

    public static Package createDepPlanPkg(Package parent, String name) {
        Package cdpPkg = parent.createNestedPackage(name);
        EObject cdp = StereotypeUtil.applyApp((Element)cdpPkg, DeploymentPlan.class);
        if (cdp == null) {
            CommandSupport.exec((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)cdpPkg), (Command)new ApplyProfile(cdpPkg, StdModelLibs.DEP_PROFILE_URI));
            StereotypeUtil.applyApp((Element)cdpPkg, DeploymentPlan.class);
        }
        return cdpPkg;
    }

    public static InstanceSpecification createDepPlan(Package cdp, Class typeOrImplem, String name, boolean createSlotsForConfigValues) throws TransformationException {
        return DepCreation.createDepPlan(cdp, typeOrImplem, name, createSlotsForConfigValues, new Stack<Classifier>());
    }

    /*
     * Unable to fully structure code
     */
    public static InstanceSpecification createDepPlan(Package cdp, Class typeOrImplem, String name, boolean createSlotsForConfigValues, Stack<Classifier> visitedClassifiers) throws TransformationException {
        if (visitedClassifiers.contains(typeOrImplem)) {
            path = "";
            for (Classifier cl : visitedClassifiers) {
                if (path.length() > 0) {
                    path = (String)path + ", ";
                }
                path = (String)path + cl.getName();
            }
            path = (String)path + ", " + typeOrImplem.getName();
            throw new TransformationException(String.format(Messages.DepCreation_CircularReference, new Object[]{typeOrImplem.getQualifiedName(), path}));
        }
        visitedClassifiers.push((Classifier)typeOrImplem);
        if (!DepUtils.isSingleton(typeOrImplem)) ** GOTO lbl21
        instanceName = "singleton_" + typeOrImplem.getName().toLowerCase();
        pe = cdp.getPackagedElement(instanceName);
        if (pe == null) {
            is = (InstanceSpecification)cdp.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
        } else {
            if (pe instanceof InstanceSpecification) {
                return (InstanceSpecification)pe;
            }
            throw new TransformationException(String.format(Messages.DepCreation_SingletonExistsAlready, new Object[]{name}));
lbl21:
            // 1 sources

            is = (InstanceSpecification)cdp.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
        }
        implementation = null;
        if (!typeOrImplem.isAbstract() || typeOrImplem instanceof Node) {
            if (typeOrImplem instanceof Class) {
                implementation = typeOrImplem;
            }
        } else {
            implementation = DepUtils.chooseImplementation(typeOrImplem, null, null);
        }
        if (!(implementation instanceof Class)) {
            throw new TransformationException(String.format(Messages.DepCreation_CannotFindImplementation, new Object[]{name, typeOrImplem.getName()}));
        }
        is.getClassifiers().add((Object)implementation);
        if (createSlotsForConfigValues) {
            DepCreation.addConfigurationOfAddedElements(cdp, is);
        }
        for (Property attribute : implementation.getAllAttributes()) {
            if (attribute instanceof Port) continue;
            type = attribute.getType();
            if (DepUtils.isComposition(attribute)) {
                if (type instanceof Class) {
                    cl = (Class)type;
                    upper = attribute.getUpper();
                    infix = "";
                    i = 0;
                    while (i < upper) {
                        partName = name + "." + attribute.getName();
                        if (upper > 1) {
                            partName = partName + "_" + infix + i;
                        }
                        partIS = DepCreation.createDepPlan(cdp, cl, partName, createSlotsForConfigValues, visitedClassifiers);
                        if (!DepUtils.isSingleton((Class)type)) {
                            DepCreation.createSlot(is, partIS, attribute);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!StereotypeUtil.isApplied((Element)attribute, ConfigurationProperty.class) || !createSlotsForConfigValues) continue;
                DepCreation.createSlotForConfigProp(is, attribute);
                continue;
            }
            if (type instanceof Class) {
                if (!DepUtils.isSingleton((Class)type)) continue;
                singletonIS = DepCreation.createDepPlan(cdp, (Class)type, "", createSlotsForConfigValues, visitedClassifiers);
                DepCreation.createSlot(is, singletonIS, attribute);
                continue;
            }
            if (type != null) continue;
            throw new TransformationException(String.format(Messages.DepCreation_TypeInAttributeUndefined, new Object[]{attribute.getName(), implementation.getName()}));
        }
        visitedClassifiers.pop();
        return is;
    }

    private static void addConfigurationOfAddedElements(Package cdp, InstanceSpecification is) throws TransformationException {
        DeploymentPlan cdpStereo;
        M2MTrafoChain chain = TrafoUtils.getTransformationChain((Package)cdp);
        if (chain != null && (cdpStereo = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)cdp, DeploymentPlan.class)) != null) {
            for (Property m2mTrafoRef : chain.getBase_Class().getAllAttributes()) {
                M2MTrafo m2mTrafo = (M2MTrafo)UMLUtil.getStereotypeApplication((Element)m2mTrafoRef.getType(), M2MTrafo.class);
                if (m2mTrafo == null) continue;
                IM2MTrafo iM2MTrafo = M2MTrafoExt.getM2MTrafo((M2MTrafo)m2mTrafo);
            }
        }
    }

    public static InstanceSpecification createPlatformInstances(Package platform, Class implementation, String name) throws TransformationException {
        InstanceSpecification is = null;
        is = (InstanceSpecification)platform.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
        is.getClassifiers().add((Object)implementation);
        for (Property attribute : implementation.getAllAttributes()) {
            if (attribute instanceof Port) continue;
            Type type = attribute.getType();
            if (!DepUtils.isComposition(attribute)) continue;
            if (type instanceof Class) {
                Class cl = (Class)type;
                int upper = attribute.getUpper();
                String infix = "";
                int i = 0;
                while (i < upper) {
                    Object partName = name != null ? name + "." : "";
                    partName = (String)partName + attribute.getName();
                    if (upper > 1) {
                        partName = (String)partName + "_" + infix + i;
                    }
                    InstanceSpecification partIS = DepCreation.createPlatformInstances(platform, cl, (String)partName);
                    if (is != null) {
                        DepCreation.createSlot(is, partIS, attribute);
                    }
                    ++i;
                }
                continue;
            }
            if (!StereotypeUtil.isApplied((Element)attribute, ConfigurationProperty.class)) continue;
            DepCreation.createSlotForConfigProp(is, attribute);
        }
        return is;
    }

    public static void initAutoValues(InstanceSpecification is) {
        ArrayList<InstanceSpecification> isList = new ArrayList<InstanceSpecification>();
        isList.add(is);
        DepCreation.initAutoValues(isList);
    }

    public static void initAutoValues(Collection<InstanceSpecification> isList) {
        map = new HashMap<Object, Integer>();
        for (InstanceSpecification is : isList) {
            DepCreation.initAutoValuesHelper(is);
        }
        Stack<InstanceSpecification> isStack = new Stack<InstanceSpecification>();
        for (InstanceSpecification is : isList) {
            DepCreation.copyAutoValues(isStack, is);
        }
    }

    public static void initAutoValuesHelper(InstanceSpecification is) {
        for (Slot slot : is.getSlots()) {
            Object key;
            StructuralFeature sf = slot.getDefiningFeature();
            if (sf == null) {
                throw new RuntimeException(String.format(Messages.DepCreation_DefiningFeatureNull, slot.getOwningInstance().getName()));
            }
            if (!StereotypeUtil.isApplied((Element)sf, AutoIndex.class)) continue;
            Integer value = null;
            if (StereotypeUtil.isApplied((Element)sf, AutoIndexPerNode.class)) {
                InstanceSpecification nodeOrThread = AllocUtils.getNode(is);
                key = sf.getName() + nodeOrThread.getName();
            } else {
                key = sf;
            }
            if (!map.containsKey(key)) {
                map.put(key, new Integer(0));
            }
            value = map.get(key);
            value = value + 1;
            LiteralInteger li = (LiteralInteger)slot.createValue(sf.getName() + "_auto", sf.getType(), UMLPackage.eINSTANCE.getLiteralInteger());
            li.setValue(value.intValue());
            for (ValueSpecification vs : slot.getValues()) {
                if (!(vs instanceof InstanceValue)) continue;
                InstanceSpecification subIS = ((InstanceValue)vs).getInstance();
                DepCreation.initAutoValues(subIS);
            }
        }
    }

    public static void copyAutoValues(Stack<InstanceSpecification> isStack, InstanceSpecification is) {
        isStack.push(is);
        for (Slot slot : is.getSlots()) {
            CopyAttributeValue cav;
            Property source;
            ValueSpecification vs;
            StructuralFeature sf = slot.getDefiningFeature();
            if (sf == null) {
                throw new TransformationRTException(is.getName() + " has a slot without defining feature");
            }
            if (StereotypeUtil.isApplied((Element)sf, CopyAttributeValue.class) && (vs = DepCreation.getNearestValue(isStack, source = (cav = (CopyAttributeValue)UMLUtil.getStereotypeApplication((Element)sf, CopyAttributeValue.class)).getSource())) instanceof LiteralInteger) {
                LiteralInteger liCopy = (LiteralInteger)slot.createValue(sf.getName() + "_copy", sf.getType(), UMLPackage.eINSTANCE.getLiteralInteger());
                int value = ((LiteralInteger)vs).getValue();
                liCopy.setValue(value);
            }
            for (ValueSpecification vs2 : slot.getValues()) {
                InstanceSpecification subIS;
                if (!(vs2 instanceof InstanceValue) || (subIS = ((InstanceValue)vs2).getInstance()) == null) continue;
                DepCreation.copyAutoValues(isStack, subIS);
            }
        }
        isStack.pop();
    }

    public static ValueSpecification getNearestValue(Stack<InstanceSpecification> isStack, Property source) {
        Stack<InstanceSpecification> copy = new Stack<InstanceSpecification>();
        copy.addAll(isStack);
        while (!copy.isEmpty()) {
            InstanceSpecification pop = (InstanceSpecification)copy.pop();
            ValueSpecification vs = DepCreation.getNearestValueHelper(isStack, pop, source);
            if (vs == null) continue;
            return vs;
        }
        return null;
    }

    public static ValueSpecification getNearestValueHelper(Stack<InstanceSpecification> isStack, InstanceSpecification is, Property source) {
        for (Slot slot : is.getSlots()) {
            StructuralFeature sf = slot.getDefiningFeature();
            if (sf == source) {
                Iterator iterator = slot.getValues().iterator();
                if (iterator.hasNext()) {
                    ValueSpecification vs = (ValueSpecification)iterator.next();
                    return vs;
                }
                return null;
            }
            for (ValueSpecification vs : slot.getValues()) {
                InstanceSpecification subIS;
                if (!(vs instanceof InstanceValue) || isStack.contains(subIS = ((InstanceValue)vs).getInstance())) continue;
                return DepCreation.getNearestValueHelper(isStack, subIS, source);
            }
        }
        return null;
    }
}

