/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;

public class CommentUtils {
    public static String cleanupComment(String comment) {
        return comment.replaceFirst(Pattern.quote("/**"), "").replace("*/", "").replaceAll("\n[ \t]* ", "\n").trim();
    }

    public static String getPreceedingComment(IASTNode node) {
        IASTComment[] iASTCommentArray = node.getTranslationUnit().getComments();
        int n = iASTCommentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            if (comment.getFileLocation().getEndingLineNumber() == node.getFileLocation().getStartingLineNumber() - 1) {
                return new String(comment.getComment());
            }
            ++n2;
        }
        return null;
    }

    public static void addComment(Element element, ISourceReference sourceRef) {
        IASTNode node = ASTUtils.findEnclosingNode(sourceRef);
        CommentUtils.addComment(element, node);
    }

    public static void addComment(Element element, IASTNode node) {
        String comment = CommentUtils.getPreceedingComment(node);
        if (comment != null) {
            Comment umlComment = element.createOwnedComment();
            umlComment.setBody(CommentUtils.cleanupComment(comment));
        }
    }
}

