/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.designer.transformation.base.Activator;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class ModelManagement {
    public static final String TEMP_UML = "temp.uml";
    public static final String UML = ".uml";
    private static ResourceSet resourceSet = null;
    private Package model;
    private Resource resource;

    public ModelManagement(Package model) {
        ModelManagement.getResourceSet();
        this.model = model;
        this.resource = resourceSet.createResource(URI.createURI((String)TEMP_UML));
        this.resource.getContents().add((Object)model);
    }

    public ModelManagement() {
        this((Package)UMLFactory.eINSTANCE.createModel());
    }

    public void dispose() {
        if (this.model != null) {
            this.model.destroy();
            this.model = null;
        }
        resourceSet.getResources().remove((Object)this.resource);
    }

    public Package getModel() {
        return this.model;
    }

    public void setURI(String path) {
        URI uri = URI.createURI((String)path);
        this.setURI(uri);
    }

    public void setURI(URI uri) {
        this.resource.setURI(uri);
    }

    public void setURI(IProject project, String modelFolder, String modelPostfix) {
        String path = this.getPath(project, modelFolder, this.getModel().getName() + modelPostfix);
        this.setURI(path);
    }

    public void save() {
        try {
            ResourceChangeListener.isSaving = true;
            this.resource.save(null);
            ResourceChangeListener.isSaving = false;
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public String getPath(IProject project, String subFolder, String filename) {
        IFile file;
        if (filename == null) {
            filename = this.model.getName() + UML;
        }
        if (subFolder != null) {
            IFolder ifolder = project.getFolder(subFolder);
            if (!ifolder.exists()) {
                try {
                    ifolder.create(false, true, null);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            file = ifolder.getFile((String)filename);
        } else {
            file = project.getFile((String)filename);
        }
        return file.getFullPath().toString();
    }

    public static ModelManagement createNewModel(String name) throws TransformationException {
        ModelManagement mm = new ModelManagement();
        Package newModel = mm.getModel();
        newModel.setName(name);
        return mm;
    }

    public static ModelManagement createNewModel(Package existingModel) throws TransformationException {
        ModelManagement mm = ModelManagement.createNewModel(existingModel.getName());
        mm.setURI(ModelManagement.getTempURI((EObject)existingModel));
        return mm;
    }

    public static ResourceSet getResourceSet() {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
        }
        return resourceSet;
    }

    public static String getTempURI(EObject eObj) {
        String uriStr = eObj.eResource().getURI().toString();
        if (uriStr.endsWith(UML)) {
            uriStr = uriStr.substring(0, uriStr.length() - 3);
        }
        return uriStr + TEMP_UML;
    }

    static class ResourceChangeListener
    implements IResourceChangeListener {
        private static boolean isSaving = false;

        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (!isSaving) {
                    delta.accept((IResourceDeltaVisitor)ResourceDeltaVisitor.instance);
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
        }
    }

    static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        static ResourceDeltaVisitor instance = new ResourceDeltaVisitor();

        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getResource().getType() == 1) {
                if (delta.getKind() == 2 || delta.getKind() == 4) {
                    URI resourceURI = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
                    ResourceSet modelSet = ModelManagement.getResourceSet();
                    Resource resource = modelSet.getResource(resourceURI, false);
                    if (resource == null) {
                        URI pluginURI = URI.createPlatformPluginURI((String)delta.getFullPath().toString(), (boolean)true);
                        resource = modelSet.getResource(pluginURI, false);
                    }
                    if (resource != null) {
                        resource.unload();
                        modelSet.getResources().remove((Object)resource);
                    }
                }
                return false;
            }
            return true;
        }
    }
}

