/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.CreateRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayRowGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.IRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupRowCommand;
import org.eclipse.nebula.widgets.nattable.group.event.GroupRowsEvent;
import org.eclipse.nebula.widgets.nattable.group.event.UngroupRowsEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderRenameDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class RowGroupsCommandHandler
extends AbstractLayerCommandHandler<IRowGroupCommand> {
    private final RowGroupHeaderLayer contextLayer;
    private final SelectionLayer selectionLayer;
    private boolean clearSelection = true;

    public RowGroupsCommandHandler(RowGroupHeaderLayer contextLayer, SelectionLayer selectionLayer) {
        this(contextLayer, selectionLayer, true);
    }

    public RowGroupsCommandHandler(RowGroupHeaderLayer contextLayer, SelectionLayer selectionLayer, boolean clearSelection) {
        this.contextLayer = contextLayer;
        this.selectionLayer = selectionLayer;
        this.clearSelection = clearSelection;
    }

    @Override
    public boolean doCommand(IRowGroupCommand command) {
        if (command instanceof CreateRowGroupCommand) {
            CreateRowGroupCommand createCommand = (CreateRowGroupCommand)command;
            if (!this.handleCreateRowGroupCommand(createCommand.getRowGroupName())) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 33);
                messageBox.setText(Messages.getString("ErrorDialog.title"));
                messageBox.setMessage(Messages.getString("RowGroups.selectNonGroupedRows"));
                messageBox.open();
            }
            return true;
        }
        if (command instanceof RemoveRowGroupCommand) {
            RemoveRowGroupCommand removeRowGroupCommand = (RemoveRowGroupCommand)command;
            int rowIndex = removeRowGroupCommand.getRowIndex();
            this.handleRemoveRowGroupCommand(rowIndex);
            return true;
        }
        if (command instanceof UngroupRowCommand) {
            this.handleUngroupCommand();
            return true;
        }
        if (command instanceof DisplayRowGroupRenameDialogCommand) {
            return this.displayRowGroupRenameDialog((DisplayRowGroupRenameDialogCommand)command);
        }
        return false;
    }

    protected boolean handleCreateRowGroupCommand(String rowGroupName) {
        GroupModel model = this.contextLayer.getGroupModel();
        MutableIntList positionsToGroup = this.getPositionsToProcess();
        if (!positionsToGroup.isEmpty()) {
            HashSet<GroupModel.Group> existingGroups = new HashSet<GroupModel.Group>();
            MutableIntIterator it = positionsToGroup.intIterator();
            while (it.hasNext()) {
                int row = it.next();
                GroupModel.Group group = model.getGroupByPosition(row);
                if (group == null) continue;
                if (!group.isUnbreakable()) {
                    existingGroups.add(group);
                    continue;
                }
                it.remove();
            }
            if (!existingGroups.isEmpty()) {
                this.contextLayer.doCommand(new RowGroupExpandCommand(model, existingGroups));
                for (GroupModel.Group group : existingGroups) {
                    positionsToGroup.addAll(group.getVisiblePositions());
                    this.contextLayer.removeGroup(group);
                }
            }
            positionsToGroup.sortThis();
            MutableIntList selectedPositions = IntLists.mutable.ofAll((IntIterable)positionsToGroup.distinct());
            if (selectedPositions.size() > 1) {
                this.selectionLayer.doCommand(new MultiRowReorderCommand((ILayer)this.selectionLayer, selectedPositions.toArray(), selectedPositions.get(0)));
            }
            this.contextLayer.addGroup(rowGroupName, this.selectionLayer.getRowIndexByPosition(selectedPositions.get(0)), selectedPositions.size());
            if (this.clearSelection) {
                this.selectionLayer.clear();
            }
            this.contextLayer.fireLayerEvent(new GroupRowsEvent(this.contextLayer));
            return true;
        }
        return false;
    }

    protected void handleRemoveRowGroupCommand(int rowIndex) {
        int selectedPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
        int converted = LayerUtil.convertRowPosition(this.selectionLayer, selectedPosition, this.contextLayer.getPositionLayer());
        GroupModel model = this.contextLayer.getGroupModel();
        GroupModel.Group group = model.getGroupByPosition(converted);
        if (group != null && !group.isUnbreakable()) {
            if (group.isCollapsed()) {
                this.contextLayer.doCommand(new RowGroupExpandCommand(model, group));
            }
            model.removeGroup(group);
            this.contextLayer.fireLayerEvent(new GroupRowsEvent(this.contextLayer));
        }
    }

    protected void handleUngroupCommand() {
        MutableIntList positionsToUngroup = this.getPositionsToProcess();
        if (!positionsToUngroup.isEmpty()) {
            GroupModel model = this.contextLayer.getGroupModel();
            HashMap toRemove = new HashMap();
            positionsToUngroup.forEach((IntProcedure & Serializable)pos -> {
                GroupModel.Group group = model.getGroupByPosition(pos);
                if (group != null) {
                    int endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    if (pos < endPos && !group.isGroupStart(pos)) {
                        MutableIntList remove = (MutableIntList)toRemove.get(group);
                        if (remove == null) {
                            remove = IntLists.mutable.empty();
                            toRemove.put(group, remove);
                        }
                        remove.add(pos);
                    } else {
                        model.removePositionsFromGroup(group, pos);
                    }
                }
            });
            if (!toRemove.isEmpty()) {
                toRemove.entrySet().forEach(entry -> {
                    GroupModel.Group group = (GroupModel.Group)entry.getKey();
                    int endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    this.selectionLayer.doCommand(new MultiRowReorderCommand((ILayer)this.selectionLayer, ((MutableIntList)entry.getValue()).toArray(), endPos));
                    MutableIntList value = (MutableIntList)entry.getValue();
                    int start = endPos - value.size();
                    int[] positionsToRemove = new int[value.size()];
                    int i = 0;
                    while (i < ((MutableIntList)entry.getValue()).size()) {
                        positionsToRemove[i] = start + i;
                        ++i;
                    }
                    model.removePositionsFromGroup(group, positionsToRemove);
                });
            }
            if (this.clearSelection) {
                this.selectionLayer.clear();
            }
            this.contextLayer.fireLayerEvent(new UngroupRowsEvent(this.contextLayer));
        }
    }

    protected MutableIntList getPositionsToProcess() {
        MutableIntList positionsToProcess = IntLists.mutable.empty();
        int[] fullySelectedRows = this.selectionLayer.getFullySelectedRowPositions();
        if (fullySelectedRows != null && fullySelectedRows.length > 0) {
            int[] nArray = fullySelectedRows;
            int n = fullySelectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                int converted = LayerUtil.convertRowPosition(this.selectionLayer, row, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToProcess.add(converted);
                }
                ++n2;
            }
        }
        return positionsToProcess;
    }

    protected boolean displayRowGroupRenameDialog(DisplayRowGroupRenameDialogCommand command) {
        int rowPosition = command.getRowPosition();
        HeaderRenameDialog dialog = new HeaderRenameDialog(Display.getDefault().getActiveShell(), null, null, HeaderRenameDialog.RenameDialogLabels.ROW_RENAME);
        Rectangle rowHeaderBounds = this.contextLayer.getBoundsByPosition(rowPosition, 0);
        Point point = new Point(rowHeaderBounds.x, rowHeaderBounds.y + rowHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (!dialog.isCancelPressed()) {
            GroupModel.Group rowGroup = this.contextLayer.getGroupByPosition(rowPosition);
            rowGroup.setName(dialog.getNewLabel());
            this.contextLayer.fireLayerEvent(new VisualRefreshEvent(this.contextLayer));
        }
        return true;
    }

    @Override
    public Class<IRowGroupCommand> getCommandClass() {
        return IRowGroupCommand.class;
    }
}

