/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.ui.emf.databinding.MultipleCellEditor;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.BooleanSelector;
import org.eclipse.papyrus.infra.widgets.selectors.IntegerSelector;
import org.eclipse.papyrus.infra.widgets.selectors.RealSelector;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.papyrus.infra.widgets.selectors.UnlimitedNaturalSelector;
import org.eclipse.swt.widgets.Composite;

public class EObjectObservableValueEditingSupport
extends EditingSupport {
    protected final String[] booleanProposals = new String[]{"true", "false"};

    public EObjectObservableValueEditingSupport(ColumnViewer viewer, ReferenceValueFactory factory) {
        super(viewer);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        Object valueType;
        if (element instanceof EObjectObservableValue && (valueType = ((EObjectObservableValue)element).getValueType()) instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)valueType;
            if (feature instanceof EReference) {
                return null;
            }
            EClassifier eType = feature.getEType();
            if (feature.isMany()) {
                return this.createMultipleCellEditor(feature, (EObjectObservableValue)element);
            }
            if (eType instanceof EEnum) {
                return this.createEnumerationEditor(feature);
            }
            String eTypeName = eType.getName();
            if (eTypeName.equals("Boolean")) {
                return this.createBooleanEditor();
            }
            if (eType instanceof EDataType) {
                return new PropertyDescriptor.EDataTypeCellEditor((EDataType)eType, (Composite)((TreeViewer)this.getViewer()).getTree());
            }
        }
        return null;
    }

    private CellEditor createMultipleCellEditor(EStructuralFeature feature, EObjectObservableValue element) {
        MultipleCellEditor multiEditor;
        block20: {
            String eTypeName;
            EClassifier eType;
            block19: {
                eType = feature.getEType();
                multiEditor = new MultipleCellEditor((Composite)((TreeViewer)this.getViewer()).getTree(), element.getObserved(), feature);
                if (!(eType instanceof EEnum)) break block19;
                ReferenceSelector referenceSelector = new ReferenceSelector(true);
                referenceSelector.setContentProvider((IStaticContentProvider)new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        return ((EEnum)eType).getELiterals().toArray();
                    }
                });
                multiEditor.setSelector((IElementSelector)referenceSelector);
                break block20;
            }
            switch (eTypeName = eType.getName()) {
                case "Integer": {
                    multiEditor.setSelector((IElementSelector)new IntegerSelector());
                    break;
                }
                case "Boolean": {
                    BooleanSelector booleanSelector = new BooleanSelector();
                    multiEditor.setSelector((IElementSelector)booleanSelector);
                    break;
                }
                case "String": {
                    multiEditor.setSelector((IElementSelector)new StringSelector());
                    break;
                }
                case "Real": {
                    multiEditor.setSelector((IElementSelector)new RealSelector());
                    break;
                }
                case "UnlimitedNatural": {
                    multiEditor.setSelector((IElementSelector)new UnlimitedNaturalSelector());
                    break;
                }
            }
        }
        return multiEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof EObjectObservableValue) {
            EObjectObservableValue observableValue = (EObjectObservableValue)element;
            EStructuralFeature feature = (EStructuralFeature)observableValue.getValueType();
            if (feature instanceof EReference) {
                return null;
            }
            EClassifier eType = feature.getEType();
            Object object = observableValue.getValue();
            if (feature.isMany()) {
                String eTypeName = eType.getName();
                if (eTypeName.equals("UnlimitedNatural")) {
                    return this.getMultiUnlimitedNaturalValue(object);
                }
                return object;
            }
            if (eType instanceof EEnum) {
                return this.getEnumerationValue((EEnum)eType, object);
            }
            String eTypeName = eType.getName();
            if (eTypeName.equals("Boolean")) {
                return this.getBooleanValue(object);
            }
            return object;
        }
        return null;
    }

    protected Object getEnumerationValue(EEnum eType, Object object) {
        EList literals = eType.getELiterals();
        if (object == null) {
            return 0;
        }
        return literals.indexOf(object);
    }

    protected Object getMultiUnlimitedNaturalValue(Object objects) {
        if (objects instanceof List) {
            ArrayList<String> objectToReturn = new ArrayList<String>();
            if (objects instanceof List) {
                int i = 0;
                while (i < ((List)objects).size()) {
                    Object object = ((List)objects).get(i);
                    String string = object.toString();
                    if (string.equals("-1")) {
                        objectToReturn.add(new String("*"));
                    } else {
                        objectToReturn.add((String)object);
                    }
                    ++i;
                }
            }
            return objectToReturn;
        }
        return objects;
    }

    protected Object getBooleanValue(Object object) {
        List<String> booleans = Arrays.asList(this.booleanProposals);
        if (object == null || object.equals("")) {
            return 0;
        }
        return booleans.indexOf(object.toString());
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof EObjectObservableValue) {
            EObjectObservableValue observableValue = (EObjectObservableValue)element;
            EStructuralFeature feature = (EStructuralFeature)observableValue.getValueType();
            if (!(feature instanceof EReference)) {
                EClassifier eType = feature.getEType();
                if (eType instanceof EEnum) {
                    this.setEnumerationValue(observableValue, value);
                } else {
                    String eTypeName = eType.getName();
                    if (eTypeName.equals("Boolean")) {
                        this.setBooleanValue(observableValue, value);
                    } else {
                        Object oldValue = observableValue.getValue();
                        if (oldValue == null || !oldValue.equals(value)) {
                            observableValue.setValue(value);
                        }
                    }
                }
            }
            this.getViewer().update(element, null);
        }
    }

    protected void setEnumerationValue(EObjectObservableValue element, Object value) {
        EStructuralFeature feature = (EStructuralFeature)element.getValueType();
        EEnum eType = (EEnum)feature.getEType();
        EList literals = eType.getELiterals();
        if (value == null) {
            element.setValue(null);
        } else if (value instanceof Collection) {
            ArrayList<Enumerator> literalsToSet = new ArrayList<Enumerator>();
            for (Object object : (Collection)value) {
                int index;
                if (object instanceof EEnumLiteral) {
                    literalsToSet.add(((EEnumLiteral)object).getInstance());
                    continue;
                }
                if (!(object instanceof Integer) || (index = ((Integer)value).intValue()) < 0 || index >= literals.size()) continue;
                literalsToSet.add(((EEnumLiteral)literals.get(index)).getInstance());
            }
            element.setValue(literalsToSet);
        } else {
            int index = (Integer)value;
            if (index >= 0 && index < literals.size() && !element.getValue().toString().equals(((EEnumLiteral)literals.get(index)).getLiteral())) {
                element.setValue((Object)((EEnumLiteral)literals.get(index)).getInstance());
            }
        }
    }

    protected void setBooleanValue(EObjectObservableValue element, Object value) {
        if (value instanceof Collection) {
            element.setValue(value);
        } else if (value != null) {
            if (value.equals(0)) {
                if (!element.getValue().toString().equals(this.booleanProposals[0])) {
                    element.setValue((Object)Boolean.valueOf(this.booleanProposals[0]));
                }
            } else if (value.equals(1)) {
                if (!element.getValue().toString().equals(this.booleanProposals[1])) {
                    element.setValue((Object)Boolean.valueOf(this.booleanProposals[1]));
                }
            } else {
                Activator.log.error("Impossible to set boolean value " + String.valueOf(value), null);
            }
        }
    }

    protected CellEditor createBooleanEditor() {
        return new ComboBoxCellEditor((Composite)((TreeViewer)this.getViewer()).getTree(), this.booleanProposals, 8);
    }

    protected CellEditor createEnumerationEditor(EStructuralFeature feature) {
        EEnum eType = (EEnum)feature.getEType();
        EList literals = eType.getELiterals();
        String[] proposals = new String[literals.size()];
        int i = 0;
        while (i < literals.size()) {
            proposals[i] = ((EEnumLiteral)literals.get(i)).getLiteral();
            ++i;
        }
        return new ComboBoxCellEditor((Composite)((TreeViewer)this.getViewer()).getTree(), proposals, 8);
    }
}

