/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowDeleteEvent;

public class RowObjectDeleteEvent
extends RowDeleteEvent {
    private Map<Integer, Object> deletedObjects = new HashMap<Integer, Object>();

    public RowObjectDeleteEvent(ILayer layer, int rowIndex, Object deletedObject) {
        super(layer, rowIndex);
        this.deletedObjects.put(rowIndex, deletedObject);
    }

    public RowObjectDeleteEvent(ILayer layer, Map<Integer, ?> deletedObjects) {
        super(layer, PositionUtil.getRanges(deletedObjects.keySet()));
        this.deletedObjects.putAll(deletedObjects);
    }

    protected RowObjectDeleteEvent(RowObjectDeleteEvent event) {
        super(event);
        this.deletedObjects.putAll(event.deletedObjects);
    }

    public Map<Integer, Object> getDeletedObjects() {
        return this.deletedObjects;
    }

    @Override
    public RowObjectDeleteEvent cloneEvent() {
        return new RowObjectDeleteEvent(this);
    }
}

