/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.uml.comment.editor.sharedresource.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.example.text.instance.papyrustextinstance.PapyrusTextInstance;
import org.eclipse.papyrus.example.text.instance.papyrustextinstance.PapyrustextinstanceFactory;
import org.eclipse.papyrus.example.uml.comment.editor.sharedresource.Activator;
import org.eclipse.papyrus.example.uml.comment.editor.sharedresource.modelresource.TextEditorModelSharedResource;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForActionHandlers;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Comment;

public class CommentEditorHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return this.getSelection().size() == 1;
    }

    protected List<EObject> getSelection() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        ArrayList<EObject> currentSelection = new ArrayList<EObject>();
        for (Object current : (IStructuredSelection)selection) {
            EObject tmp;
            if (!(current instanceof IAdaptable) || (tmp = (EObject)((IAdaptable)current).getAdapter(EObject.class)) == null || !(tmp instanceof Comment)) continue;
            currentSelection.add(tmp);
        }
        return currentSelection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.runAsTransaction();
        }
        catch (ServiceException e) {
            throw new ExecutionException("I can't create CompareEditor", (Throwable)e);
        }
        return null;
    }

    public void runAsTransaction() throws ServiceException {
        final ServicesRegistry serviceRegistry = ServiceUtilsForActionHandlers.getInstance().getServiceRegistry();
        TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        AbstractEMFOperation command = new AbstractEMFOperation(domain, "Create CompareEditor"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    CommentEditorHandler.this.doExecute(serviceRegistry);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                catch (NotFoundException e) {
                    Activator.log.error((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        try {
            CheckedOperationHistory.getInstance().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error("I can't create CompareEditor", (Throwable)e);
        }
    }

    public void doExecute(ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        Object editorModel = this.createEditorModel(serviceRegistry);
        IPageManager pageMngr = ServiceUtils.getInstance().getIPageManager((Object)serviceRegistry);
        pageMngr.openPage(editorModel);
    }

    protected Object createEditorModel(ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        PapyrusTextInstance editorModel = PapyrustextinstanceFactory.eINSTANCE.createPapyrusTextInstance();
        editorModel.setEditedObject(this.getSelection().get(0));
        editorModel.setType("CommentEditorSharedResource");
        editorModel.setName("Comment Editor Shared Resource");
        TextEditorModelSharedResource model = (TextEditorModelSharedResource)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.example.text.TextEditorModelSharedResource");
        model.addPapyrusTextInstance(editorModel);
        return editorModel;
    }
}

