/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableList;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.DiagramLabelObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.GradientObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.provider.ModelContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.properties.util.LegacyOwnerObservable;
import org.eclipse.papyrus.infra.gmfdiag.style.StylePackage;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.graphics.Image;

public class GMFModelElement
extends EMFModelElement {
    public GMFModelElement(EObject source) {
        super(source);
    }

    public GMFModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean result = true;
        result = "label".equals(propertyPath) ? true : (propertyPath.endsWith("owner") ? true : super.isFeatureEditable(propertyPath));
        return result;
    }

    protected IObservable doGetObservable(String propertyPath) {
        if ("label".equals(propertyPath)) {
            Diagram diagram = (Diagram)this.source;
            return new DiagramLabelObservableValue(diagram, this.getDomain());
        }
        if (propertyPath.endsWith("owner")) {
            Diagram diagram = (Diagram)this.source;
            Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE);
            if (style != null) {
                return new GMFObservableValue((EObject)style, (EStructuralFeature)StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE__OWNER, this.domain);
            }
            return new LegacyOwnerObservable(diagram, (EStructuralFeature)StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE__OWNER, this.domain);
        }
        if (propertyPath.endsWith("prototype")) {
            Diagram diagram = (Diagram)this.source;
            Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE);
            if (style != null) {
                return new GMFObservableValue((EObject)style, (EStructuralFeature)StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE__DIAGRAM_KIND_ID, this.domain);
            }
            return new LegacyOwnerObservable(diagram, (EStructuralFeature)StylePackage.Literals.PAPYRUS_DIAGRAM_STYLE__DIAGRAM_KIND_ID, this.domain);
        }
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return null;
        }
        if (feature.getEType() == NotationPackage.eINSTANCE.getGradientData()) {
            return new GradientObservableValue(this.source, feature, this.domain);
        }
        if (feature.getUpperBound() != 1) {
            GMFObservableList list = this.domain == null ? EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source) : new GMFObservableList((List)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
            return list;
        }
        GMFObservableValue value = this.domain == null ? EMFProperties.value((FeaturePath)featurePath).observe((Object)this.source) : new GMFObservableValue(this.getSource(featurePath), feature, this.domain);
        return value;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if (propertyPath.endsWith("prototype")) {
            return new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public Image getImage(Object element) {
                    ViewPrototype proto = DiagramUtils.getPrototype((Diagram)((Diagram)GMFModelElement.this.source));
                    return proto.getIcon();
                }

                public String getText(Object element) {
                    ViewPrototype proto = DiagramUtils.getPrototype((Diagram)((Diagram)GMFModelElement.this.source));
                    return proto.getQualifiedName();
                }
            };
        }
        LabelProvider result = null;
        try {
            ResourceSet rset = EMFHelper.getResourceSet((EObject)this.source);
            if (rset != null) {
                result = ((LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)rset)).getLabelProvider();
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        if (result == null) {
            result = new LabelProvider();
        }
        return result;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if ("element".equals(propertyPath)) {
            if (this.source instanceof Diagram) {
                Diagram diagram = (Diagram)this.source;
                return new ModelContentProvider(diagram, this.getRoot(diagram.getElement())){

                    @Override
                    protected boolean isValid(EObject selection, Diagram diagram, ViewPrototype prototype) {
                        return PolicyChecker.getFor((EObject)diagram).canHaveNewView(selection, DiagramUtils.getOwner((Diagram)diagram), prototype);
                    }
                };
            }
            return EmptyContentProvider.instance;
        }
        if ("owner".equals(propertyPath)) {
            Diagram diagram = (Diagram)this.source;
            return new ModelContentProvider(diagram, this.getRoot(diagram.getElement())){

                @Override
                protected boolean isValid(EObject selection, Diagram diagram, ViewPrototype prototype) {
                    return PolicyChecker.getFor((EObject)diagram).getOwningRuleFor(prototype, selection) != null;
                }
            };
        }
        return super.getContentProvider(propertyPath);
    }

    private EObject getRoot(EObject obj) {
        EObject current = obj;
        if (obj != null) {
            EObject parent = obj.eContainer();
            while (parent != null) {
                current = parent;
                parent = parent.eContainer();
            }
        }
        return current;
    }
}

