/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConvertCommentCommandBase
extends AbstractTransactionalCommand {
    public ConvertCommentCommandBase(TransactionalEditingDomain domain, String label, List<?> affectedFiles) {
        super(domain, label, affectedFiles);
    }

    protected void migrateLink(Edge noteLink, Edge result) {
        Anchor targetAnchor;
        Anchor sourceAnchor;
        Bendpoints bendpoints = noteLink.getBendpoints();
        if (bendpoints != null) {
            result.setBendpoints(ConvertCommentCommandBase.makeCopy(bendpoints));
        }
        if ((sourceAnchor = noteLink.getSourceAnchor()) != null) {
            result.setSourceAnchor(ConvertCommentCommandBase.makeCopy(sourceAnchor));
        }
        if ((targetAnchor = noteLink.getTargetAnchor()) != null) {
            result.setTargetAnchor(ConvertCommentCommandBase.makeCopy(targetAnchor));
        }
    }

    protected void migrateNode(Node originalNode, Node convertedNode) {
        LayoutConstraint layoutConstraint = originalNode.getLayoutConstraint();
        if (layoutConstraint != null) {
            convertedNode.setLayoutConstraint(ConvertCommentCommandBase.makeCopy(layoutConstraint));
        }
    }

    private static <T extends EObject> T makeCopy(T original) {
        return (T)EcoreUtil.copy(original);
    }

    public static interface Config {
        public int getCommentVisualID();

        public int getAnnotatedElementVisualID();

        public IElementType getAnnotatedElementElementType();

        public String getNoteAttachmentVisualID();

        public String getNoteVisualId();
    }

    public static class ConfigImpl
    implements Config {
        private final int myCommentNodeVID;
        private final IElementType myCommentLinkElementType;
        private final int myCommentLinkVID;

        public ConfigImpl(int commentNodeVID, int commentLinkVID, IElementType commentLinkElementType) {
            this.myCommentNodeVID = commentNodeVID;
            this.myCommentLinkVID = commentLinkVID;
            this.myCommentLinkElementType = commentLinkElementType;
        }

        public String getNoteAttachmentVisualID() {
            return ViewType.NOTEATTACHMENT;
        }

        public String getNoteVisualId() {
            return ViewType.NOTE;
        }

        public IElementType getAnnotatedElementElementType() {
            return this.myCommentLinkElementType;
        }

        public int getCommentVisualID() {
            return this.myCommentNodeVID;
        }

        public int getAnnotatedElementVisualID() {
            return this.myCommentLinkVID;
        }
    }
}

