/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.HashMap;
import java.util.Map;

public class ProblemLimit {
    Map<Integer, Integer> limitsBySeverity = new HashMap<Integer, Integer>();
    Map<Integer, String> messagesBySeverity = new HashMap<Integer, String>();

    public String check(int severity, String message) {
        return message;
    }

    public void setLimit(int severity, int limit, String message) {
        if (severity < 0) {
            throw new IllegalArgumentException("Given severity is less than 0--must be 0 or greater");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Given limit is less than 0--must be 0 or greater");
        }
        if (message == null) {
            throw new IllegalArgumentException("Given memssage is null; must not be null");
        }
        this.limitsBySeverity.remove(severity);
        this.limitsBySeverity.put(severity, limit);
        this.messagesBySeverity.remove(severity);
        this.messagesBySeverity.put(severity, message);
    }

    public void clearLimit(int severity) {
        this.limitsBySeverity.remove(severity);
        this.messagesBySeverity.remove(severity);
    }

    public void clearAllLimits() {
        this.limitsBySeverity.clear();
        this.messagesBySeverity.clear();
    }

    public boolean isLimited(int severity) {
        return this.limitsBySeverity.containsKey(severity);
    }

    public int getLimit(int severity, int defaultLimit) {
        if (!this.isLimited(severity)) {
            return defaultLimit;
        }
        return this.limitsBySeverity.get(severity);
    }

    public String getMessage(int severity, String defaultMessage) {
        if (!this.isLimited(severity)) {
            return defaultMessage;
        }
        return this.messagesBySeverity.get(severity);
    }

    public static class LimitExceededException
    extends Exception {
        private static final long serialVersionUID = 1L;

        LimitExceededException(String message) {
            super(message);
        }
    }
}

