/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;

public class QvtCompilerFacade {
    private QvtCompilerFacade() {
    }

    public static CompilationResult getCompiledModule(URI uriTransf) throws MdaException {
        QvtCompilerOptions compilerOptions = new QvtCompilerOptions();
        compilerOptions.setGenerateCompletionData(false);
        return QvtCompilerFacade.getCompiledModule(uriTransf, compilerOptions, null);
    }

    public static CompilationResult getCompiledModule(URI uriTransf, QvtCompilerOptions compilerOptions, IProgressMonitor monitor) throws MdaException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CompilerMessages.QvtCompilerFacade_compilingScript, 4);
        try {
            monitor.subTask(CompilerMessages.QvtCompilerFacade_acquiringScript);
            IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uriTransf);
            monitor.worked(1);
            QvtEngine qvtEngine = QvtEngine.getInstance((IResource)ifile);
            final CompiledModule module = qvtEngine.compile((CFile)new EclipseFile(ifile), compilerOptions, (IProgressMonitor)new SubProgressMonitor(monitor, 2)).getModule();
            final QvtCompiler compiler = qvtEngine.getCompiler();
            CompilationResult compilationResult = new CompilationResult(){

                public CompiledModule getCompiledModule() {
                    return module;
                }

                public QvtCompiler getCompiler() {
                    return compiler;
                }
            };
            return compilationResult;
        }
        finally {
            monitor.done();
        }
    }

    public static interface CompilationResult {
        public QvtCompiler getCompiler();

        public CompiledModule getCompiledModule();
    }
}

