/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.INewQVTElementDestinationWizardDelegate;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.INewQVTProjectElementWizard;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QVTWizardListSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    private static final String POINT_ID = "projectElementsWizards";
    private static final String REF_ID_ATTR = "refId";
    private TableViewer myWizardSelectionViewer;
    private Button myUseTransformation;
    private WizardElement myOldSelectedWizardElement;
    private Text myDescriptionText;
    private INewQVTElementDestinationWizardDelegate fDestinationProvider;

    QVTWizardListSelectionPage(INewQVTElementDestinationWizardDelegate destinationProvider) {
        super(QVTWizardListSelectionPage.class.getSimpleName());
        if (destinationProvider == null) {
            throw new IllegalArgumentException();
        }
        this.setTitle(Messages.WizardListSelectionPage_title);
        this.setDescription(QVTWizardListSelectionPage.getWizardListPageDescription());
        this.fDestinationProvider = destinationProvider;
    }

    public boolean canFlipToNextPage() {
        if (this.myUseTransformation.getSelection() && this.getSelectedNode() == null) {
            return false;
        }
        if (this.validate() != null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTransormationCheckBtn(container, 1);
        Label label = new Label(container, 0);
        label.setText(Messages.WizardListSelectionPage_message);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 256);
        gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        this.myWizardSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        this.myWizardSelectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.myWizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ((WizardElement)element).image;
            }

            public String getText(Object element) {
                WizardElement wizardElement = (WizardElement)element;
                IWizardCategory category = wizardElement.descriptor.getCategory();
                if (category == null) {
                    return wizardElement.name;
                }
                return wizardElement.name;
            }
        });
        this.myWizardSelectionViewer.setComparator((ViewerComparator)new WizardComparator());
        this.myWizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QVTWizardListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)QVTWizardListSelectionPage.this.myWizardSelectionViewer, QVTWizardListSelectionPage.this.myWizardSelectionViewer.getSelection()));
                QVTWizardListSelectionPage.this.getContainer().showPage(QVTWizardListSelectionPage.this.getNextPage());
            }
        });
        this.myDescriptionText = new Text((Composite)sashForm, 2048);
        GridData descGD = new GridData(1808);
        descGD.widthHint = 200;
        this.myDescriptionText.setLayoutData((Object)descGD);
        this.myWizardSelectionViewer.setInput(this.getAvailableTransformationWizards());
        this.myWizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        this.setSelectionToViewer();
        this.updateControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml.transformation_project");
    }

    public boolean isPageComplete() {
        this.setErrorMessage(this.validate());
        return !this.myUseTransformation.getSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.myUseTransformation.setFocus();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardElement currentWizardSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentWizardSelection = (WizardElement)iter.next();
        }
        if (currentWizardSelection == null) {
            this.myDescriptionText.setText("");
            this.setSelectedNode(null);
            return;
        }
        WizardElement finalSelection = currentWizardSelection;
        this.setSelectedNode(new WizardNode(finalSelection));
        this.myDescriptionText.setText(finalSelection.description);
        this.getContainer().updateButtons();
    }

    protected void createTransormationCheckBtn(Composite container, int span) {
        this.myUseTransformation = new Button(container, 32);
        this.myUseTransformation.setText(Messages.WizardListSelectionPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.myUseTransformation.setLayoutData((Object)gd);
        this.myUseTransformation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QVTWizardListSelectionPage.this.updateControl();
            }
        });
        this.myUseTransformation.setSelection(false);
    }

    private void updateControl() {
        if (!this.myUseTransformation.getSelection()) {
            IStructuredSelection selection = (IStructuredSelection)this.myWizardSelectionViewer.getSelection();
            this.myOldSelectedWizardElement = (WizardElement)selection.getFirstElement();
        }
        this.setSelectionToViewer();
        this.myWizardSelectionViewer.getControl().setEnabled(this.myUseTransformation.getSelection());
        this.myDescriptionText.setEnabled(this.myUseTransformation.getSelection());
        if (this.myUseTransformation.getSelection()) {
            this.myWizardSelectionViewer.getControl().forceFocus();
        }
    }

    private void setSelectionToViewer() {
        if (this.myUseTransformation.getSelection()) {
            List input = (List)this.myWizardSelectionViewer.getInput();
            WizardElement welement = null;
            if (this.myOldSelectedWizardElement != null) {
                welement = this.myOldSelectedWizardElement;
            } else if (!input.isEmpty()) {
                welement = (WizardElement)input.get(0);
            }
            if (welement != null) {
                this.myWizardSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)welement));
                this.setSelectedNode(new WizardNode(welement));
                this.myDescriptionText.setText(welement.description);
            }
        } else {
            this.myWizardSelectionViewer.setSelection((ISelection)new StructuredSelection());
            this.setSelectedNode(null);
            this.myDescriptionText.setText("");
        }
    }

    private List<WizardElement> getAvailableTransformationWizards() {
        IWizardRegistry wizardRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        ArrayList<WizardElement> wizards = new ArrayList<WizardElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.qvt.oml.ui", POINT_ID);
        if (point == null) {
            return wizards;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            final IExtension nextExtension = extensions[i];
            IPluginContribution contribution = new IPluginContribution(){

                public String getLocalId() {
                    return nextExtension.getSimpleIdentifier();
                }

                public String getPluginId() {
                    return nextExtension.getContributor().getName();
                }
            };
            if (!WorkbenchActivityHelper.filterItem((Object)contribution)) {
                IConfigurationElement[] elements = nextExtension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IWizardDescriptor wizardDescriptor;
                    IConfigurationElement element = elements[j];
                    String refID = element.getAttribute(REF_ID_ATTR);
                    if (refID != null && (wizardDescriptor = wizardRegistry.findWizard(refID)) != null) {
                        wizards.add(new WizardElement(wizardDescriptor));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return wizards;
    }

    private String validate() {
        return null;
    }

    private static String getWizardListPageDescription() {
        return Messages.WizardListSelectionPage_desc;
    }

    private static class WizardComparator
    extends ViewerComparator {
        private WizardComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            WizardElement w1 = (WizardElement)e1;
            WizardElement w2 = (WizardElement)e2;
            return WizardComparator.safeName(w1).compareTo(WizardComparator.safeName(w2));
        }

        static String safeName(WizardElement we) {
            return we.name != null ? we.name : "";
        }
    }

    private static class WizardElement {
        Image image;
        String name;
        String description;
        IWizardDescriptor descriptor;

        WizardElement(IWizardDescriptor descriptor) {
            assert (descriptor != null);
            this.name = descriptor.getLabel();
            this.description = descriptor.getDescription();
            if (descriptor.getImageDescriptor() != null) {
                this.image = descriptor.getImageDescriptor().createImage();
            }
            this.descriptor = descriptor;
        }

        void dispose() {
            if (this.image != null) {
                this.image.dispose();
            }
        }

        IWizard createWizard() throws CoreException {
            return this.descriptor.createWizard();
        }
    }

    private class WizardNode
    implements IWizardNode {
        WizardElement myWizardElement;
        INewQVTProjectElementWizard myWizard;

        public WizardNode(WizardElement element) {
            assert (element != null);
            this.myWizardElement = element;
        }

        public void dispose() {
            if (this.myWizardElement != null) {
                this.myWizardElement.dispose();
            }
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (!QVTWizardListSelectionPage.this.myUseTransformation.getSelection()) {
                return null;
            }
            if (this.myWizard == null && QVTWizardListSelectionPage.this.getSelectedNode() != null) {
                try {
                    IWizard wizard = this.myWizardElement.createWizard();
                    if (wizard instanceof INewQVTProjectElementWizard) {
                        this.myWizard = (INewQVTProjectElementWizard)wizard;
                    }
                }
                catch (CoreException e) {
                    QVTUIPlugin.log(e);
                }
                if (this.myWizard == null) {
                    return null;
                }
                this.myWizard.init(QVTWizardListSelectionPage.this.fDestinationProvider);
                this.myWizard.addPages();
            }
            return this.myWizard;
        }

        public boolean isContentCreated() {
            IWizard wizard = this.getWizard();
            return wizard != null ? ((INewQVTProjectElementWizard)this.getWizard()).isContentCreated() : false;
        }
    }
}

