/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class TypeURIHelper
implements URIHelperConstants {
    public String getFragment(String signature) {
        StringBuilder uriBuilder = new StringBuilder(32);
        this.createFragment(signature, uriBuilder);
        return uriBuilder.toString();
    }

    public URI createResourceURI(String signature) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(signature, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public URI createResourceURIFromString(String withoutProtocol) {
        StringBuilder uriBuilder = new StringBuilder("java".length() + 1 + withoutProtocol.length());
        uriBuilder.append("java").append(":").append(withoutProtocol);
        return this.createURI(uriBuilder);
    }

    public StringBuilder createURIBuilder() {
        StringBuilder builder = new StringBuilder(48);
        builder.append("java");
        builder.append(':');
        return builder;
    }

    protected URI createURI(StringBuilder uriBuilder) {
        return URI.createURI((String)uriBuilder.toString());
    }

    public URI getFullURI(ITypeBinding typeBinding) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.getFullURI(typeBinding, uriBuilder);
        return this.createURI(uriBuilder);
    }

    protected void getFullURI(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createResourceURI(typeBinding, uriBuilder);
        uriBuilder.append('#');
        this.createFragment(typeBinding, uriBuilder);
    }

    public URI getFullURI(IVariableBinding binding) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.getFullURI(binding.getDeclaringClass(), uriBuilder);
        uriBuilder.append(".");
        uriBuilder.append(binding.getName());
        return this.createURI(uriBuilder);
    }

    public URI getFullURI(IMethodBinding binding) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.getFullURI(binding.getDeclaringClass(), uriBuilder);
        uriBuilder.append(".");
        uriBuilder.append(binding.getName());
        uriBuilder.append("(");
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                uriBuilder.append(',');
            }
            uriBuilder.append(this.getQualifiedName(parameterTypes[i]));
            ++i;
        }
        uriBuilder.append(")");
        return this.createURI(uriBuilder);
    }

    public URI getFullURI(IBinding binding) {
        if (binding instanceof ITypeBinding) {
            return this.getFullURI((ITypeBinding)binding);
        }
        if (binding instanceof IMethodBinding) {
            return this.getFullURI((IMethodBinding)binding);
        }
        if (binding instanceof IVariableBinding) {
            return this.getFullURI((IVariableBinding)binding);
        }
        return null;
    }

    public URI getFullURI(IJavaElement javaElement) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(javaElement.getJavaProject());
        IBinding[] bindings = parser.createBindings(new IJavaElement[]{javaElement}, null);
        if (bindings[0] != null) {
            return this.getFullURI(bindings[0]);
        }
        return null;
    }

    public URI getFullURIForClass(String fqn) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURIForClassImpl2(fqn, uriBuilder);
        uriBuilder.append('#');
        this.createFragmentForClass2(fqn, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public URI getFullURI(ITypeBinding typeBinding, String method) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.getFullURI(typeBinding, uriBuilder);
        uriBuilder.append('.').append(method).append("()");
        return this.createURI(uriBuilder);
    }

    protected void createFragment(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.isPrimitive()) {
            this.createFragmentForPrimitive(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isArray()) {
            this.createFragmentForArray(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isTypeVariable()) {
            this.createFragmentForTypeVariable(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isAnnotation() || typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isEnum()) {
            this.createFragmentForClass(typeBinding, uriBuilder);
            return;
        }
        throw new IllegalStateException("Unexpected type binding: " + typeBinding);
    }

    protected void createFragment(String signature, StringBuilder uriBuilder) {
        int signatureKind = Signature.getTypeSignatureKind((String)signature);
        switch (signatureKind) {
            case 2: {
                this.createFragmentForPrimitive(signature, uriBuilder);
                return;
            }
            case 1: {
                this.createFragmentForClass(signature, uriBuilder);
                return;
            }
            case 4: {
                this.createFragmentForArray(signature, uriBuilder);
                return;
            }
            case 3: {
                this.createFragmentForTypeVariable(signature, uriBuilder);
                return;
            }
        }
        throw new IllegalStateException("Unexpected Signature: " + signature);
    }

    protected void createFragmentForTypeVariable(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.getDeclaringMethod() != null) {
            this.createFragmentForMethod(typeBinding.getDeclaringMethod(), uriBuilder);
        } else {
            this.createFragment(typeBinding.getDeclaringClass(), uriBuilder);
        }
        uriBuilder.append('/');
        uriBuilder.append(typeBinding.getName());
    }

    protected void createFragmentForTypeVariable(String signature, StringBuilder uriBuilder) {
        String readable = Signature.toString((String)signature);
        uriBuilder.append('/');
        uriBuilder.append(readable);
    }

    protected void createFragmentForMethod(IMethodBinding method, StringBuilder uriBuilder) {
        ITypeBinding declaringType = method.getDeclaringClass();
        this.createFragmentForClass(declaringType, uriBuilder);
        uriBuilder.append('.');
        uriBuilder.append(method.getName());
        uriBuilder.append('(');
        ITypeBinding[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                uriBuilder.append(',');
            }
            uriBuilder.append(this.getQualifiedName(parameterTypes[i]));
            ++i;
        }
        uriBuilder.append(')');
    }

    public String getQualifiedName(ITypeBinding binding) {
        if (binding.isParameterizedType()) {
            return this.getQualifiedName(binding.getErasure());
        }
        if (binding.isArray()) {
            return String.valueOf(this.getQualifiedName(binding.getComponentType())) + "[]";
        }
        if (binding.isTopLevel() || binding.isTypeVariable() || binding.isPrimitive()) {
            return binding.getQualifiedName();
        }
        return String.valueOf(this.getQualifiedName(binding.getDeclaringClass())) + "$" + binding.getName();
    }

    public String computeTypeName(String signature) {
        StringBuilder result = new StringBuilder(64);
        this.computeTypeName(signature, result);
        return result.toString();
    }

    public void computeTypeName(String signature, StringBuilder uriBuilder) {
        int signatureKind = Signature.getTypeSignatureKind((String)signature);
        switch (signatureKind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String erased = this.getTypeErasure(signature);
                uriBuilder.append(Signature.toString((String)erased));
                return;
            }
        }
        throw new IllegalStateException("Unexpected Signature: " + signature);
    }

    public String getTypeErasure(String signature) {
        String fixedSignature = signature.replaceAll(">\\.", ">\\$");
        return Signature.getTypeErasure((String)fixedSignature);
    }

    public String computeParameterizedTypeName(String signature) {
        StringBuilder result = new StringBuilder(64);
        this.computeParameterizedTypeName(signature, result);
        return result.toString();
    }

    public void computeParameterizedTypeName(String signature, StringBuilder uriBuilder) {
        this.computeTypeName(signature, uriBuilder);
        String[] typeArguments = Signature.getTypeArguments((String)signature);
        if (typeArguments.length != 0) {
            uriBuilder.append('<');
            int i = 0;
            while (i < typeArguments.length) {
                if (i != 0) {
                    uriBuilder.append(',');
                }
                this.computeParameter(typeArguments[i], uriBuilder);
                ++i;
            }
            uriBuilder.append('>');
        }
    }

    public void computeParameter(String signature, StringBuilder uriBuilder) {
        block6: {
            block5: {
                int signatureKind = Signature.getTypeSignatureKind((String)signature);
                if (signatureKind != 5) break block5;
                switch (signature.charAt(0)) {
                    case '*': {
                        uriBuilder.append("? extends java.lang.Object");
                        break block6;
                    }
                    case '+': {
                        uriBuilder.append("? extends ");
                        String upperBoundSignature = signature.substring(1);
                        this.computeParameterizedTypeName(upperBoundSignature, uriBuilder);
                        break block6;
                    }
                    case '-': {
                        uriBuilder.append("? extends java.lang.Object & super ");
                        String lowerBoundSignature = signature.substring(1);
                        this.computeParameterizedTypeName(lowerBoundSignature, uriBuilder);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Signature: " + signature);
                    }
                }
            }
            this.computeParameterizedTypeName(signature, uriBuilder);
        }
    }

    protected void createFragmentForPrimitive(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        uriBuilder.append(typeBinding.getName());
    }

    protected void createFragmentForPrimitive(String signature, StringBuilder uriBuilder) {
        uriBuilder.append(Signature.toString((String)signature));
    }

    protected void createFragmentForArray(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createFragment(typeBinding.getComponentType(), uriBuilder);
        uriBuilder.append("[]");
    }

    protected void createFragmentForArray(String signature, StringBuilder uriBuilder) {
        String elementType = Signature.getElementType((String)signature);
        this.createFragment(elementType, uriBuilder);
        int dim = Signature.getArrayCount((String)signature);
        int i = 0;
        while (i < dim) {
            uriBuilder.append("[]");
            ++i;
        }
    }

    protected void createFragmentForClass(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        this.createFragmentForClass2(this.getQualifiedName(typeBinding), uriBuilder);
    }

    protected void createFragmentForClass2(String fqn, StringBuilder uriBuilder) {
        uriBuilder.append(fqn);
    }

    protected void createFragmentForClass(String signature, StringBuilder uriBuilder) {
        String fragment = Signature.toString((String)signature);
        int start = signature.length();
        int lastDot = fragment.length();
        while ((start = signature.lastIndexOf(36, start)) >= 0) {
            lastDot = fragment.lastIndexOf(46, lastDot);
            fragment = String.valueOf(fragment.substring(0, lastDot)) + '$' + fragment.substring(lastDot + 1);
            --start;
        }
        uriBuilder.append(fragment);
    }

    protected void createResourceURI(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.isPrimitive()) {
            this.createResourceURIForPrimitive(uriBuilder);
            return;
        }
        if (typeBinding.isArray()) {
            this.createResourceURIForArray(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isTypeVariable()) {
            this.createResourceURIForTypeVariable(typeBinding, uriBuilder);
            return;
        }
        if (typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotation() || typeBinding.isEnum()) {
            this.createResourceURIForClass(typeBinding, uriBuilder);
            return;
        }
        throw new IllegalStateException("Unexpected type: " + typeBinding);
    }

    protected void createResourceURI(String signature, StringBuilder uriBuilder) {
        try {
            int signatureKind = Signature.getTypeSignatureKind((String)signature);
            switch (signatureKind) {
                case 2: {
                    this.createResourceURIForPrimitive(uriBuilder);
                    return;
                }
                case 1: {
                    this.createResourceURIForClass(signature, uriBuilder);
                    return;
                }
                case 4: {
                    this.createResourceURIForArray(signature, uriBuilder);
                    return;
                }
            }
            throw new IllegalStateException("Unexpected Signature: " + signature);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + " was: " + signature, e);
        }
    }

    protected void createResourceURIForPrimitive(StringBuilder uriBuilder) {
        uriBuilder.append("/Primitives");
    }

    protected void createResourceURIForArray(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        ITypeBinding componentType = typeBinding.getComponentType();
        this.createResourceURI(componentType, uriBuilder);
    }

    protected void createResourceURIForArray(String signature, StringBuilder uriBuilder) {
        String elementType = Signature.getElementType((String)signature);
        this.createResourceURI(elementType, uriBuilder);
    }

    protected void createResourceURIForClass(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.getDeclaringClass() != null) {
            this.createResourceURIForClass(typeBinding.getDeclaringClass(), uriBuilder);
        } else {
            this.createResourceURIForClassImpl2(typeBinding.getQualifiedName(), uriBuilder);
        }
    }

    protected void createResourceURIForClass(String signature, StringBuilder uriBuilder) {
        this.createResourceURIForClassImpl(signature, uriBuilder);
    }

    protected void createResourceURIForClassImpl2(String fqn, StringBuilder uriBuilder) {
        uriBuilder.append("/Objects/").append(fqn);
    }

    protected void createResourceURIForClassImpl(String signature, StringBuilder uriBuilder) {
        String topLevel = signature;
        int idx = topLevel.indexOf(36);
        if (idx != -1) {
            topLevel = String.valueOf(topLevel.substring(0, idx)) + ';';
        }
        uriBuilder.append("/Objects/").append(Signature.toString((String)topLevel));
    }

    protected void createResourceURIForTypeVariable(ITypeBinding typeBinding, StringBuilder uriBuilder) {
        if (typeBinding.getDeclaringClass() != null) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            this.createResourceURIForClass(declaringClass, uriBuilder);
        } else {
            IMethodBinding declaringMethod = typeBinding.getDeclaringMethod();
            ITypeBinding declaringClass = declaringMethod.getDeclaringClass();
            this.createResourceURIForClass(declaringClass, uriBuilder);
        }
    }
}

