/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class FileOpener {
    private static final Logger logger = Logger.getLogger(FileOpener.class);
    @Inject
    private IWorkbench workbench;

    public void selectAndReveal(IFile file) {
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    public void openFileToEdit(Shell shell, final IFile file) {
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = FileOpener.this.workbench.getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

