/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.clustering.IUniqueURIQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueURIQueue
implements IUniqueURIQueue {
    private static final Logger logger = Logger.getLogger(UniqueURIQueue.class);
    private final Queue<URI> delegate = Lists.newLinkedList();
    private final Set<URI> allURIs = Sets.newHashSet();

    private UniqueURIQueue() {
    }

    protected UniqueURIQueue(Collection<URI> initial) {
        this();
        this.allURIs.addAll(initial);
        this.delegate.addAll(this.allURIs);
    }

    @Override
    public void add(URI uri) {
        if (this.allURIs.add(uri)) {
            this.delegate.add(uri);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Queue element no " + this.delegate.size() + " (" + this.allURIs.size() + "): " + uri.toString()));
            }
        }
    }

    @Override
    public URI remove() {
        if (this.isEmpty()) {
            return null;
        }
        URI result = this.delegate.poll();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get element no " + (this.delegate.size() + 1) + ": " + result.toString()));
        }
        return result;
    }

    public Collection<URI> getAllURIs() {
        return Collections.unmodifiableSet(this.allURIs);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int totalSize() {
        return this.allURIs.size();
    }

    @Override
    public int currentSize() {
        return this.delegate.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements IUniqueURIQueue.Factory {
        @Override
        public UniqueURIQueue create(Collection<URI> initial) {
            return new UniqueURIQueue(initial);
        }
    }
}

