/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;
import org.eclipse.xtext.ui.internal.Activator;

@Singleton
public class PreferenceStoreAccessImpl
implements IPreferenceStoreAccess {
    private String qualifier;
    private boolean initialized = false;
    @Inject
    private IPreferenceStoreInitializer.CompositeImpl initializer;

    public IPreferenceStore getPreferenceStore() {
        this.lazyInitialize();
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(), Activator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()});
    }

    public IPreferenceStore getContextPreferenceStore(Object context) {
        this.lazyInitialize();
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(context), this.getPreferenceStore()});
    }

    public IPreferenceStore getWritablePreferenceStore() {
        this.lazyInitialize();
        return new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), this.getQualifier());
    }

    public IPreferenceStore getWritablePreferenceStore(Object context) {
        this.lazyInitialize();
        if (context instanceof IFileEditorInput) {
            context = ((IFileEditorInput)context).getFile().getProject();
        }
        if (context instanceof IProject) {
            return new ScopedPreferenceStore((IScopeContext)new ProjectScope((IProject)context), this.getQualifier());
        }
        return this.getWritablePreferenceStore();
    }

    @Inject
    public void setLanguageNameAsQualifier(@Named(value="languageName") String languageName) {
        this.qualifier = languageName;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected void lazyInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.initializer.initialize(this);
        }
    }
}

