/*******************************************************************************
 * Copyright (c) 2010 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtext.ui.label;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;

/**
 * @author koehnlein - Initial contribution and API
 */
public class DefaultEditorImageUtil {
	public ImageDescriptor getDefaultEditorImageDescriptor(String fileName) {
		if (fileName != null) {
			IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileName);
			if (defaultEditor != null) {
				return defaultEditor.getImageDescriptor();
			}
		}
		return null;
	}
}
