/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.ui.contentassist.WhitespaceHelper;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacingAppendable
extends StringBuilderBasedAppendable {
    private static final Logger LOG = Logger.getLogger(ReplacingAppendable.class);
    private List<String> existingImports;
    private IXtextDocument document;
    private XtendFile xtendFile;
    private final WhitespaceHelper whitespaceHelper;

    public ReplacingAppendable(ImportManager importManager, String indentString, IXtextDocument document, XtendFile xtendFile, WhitespaceHelper whitespaceHelper) {
        super(importManager, indentString);
        this.document = document;
        this.xtendFile = xtendFile;
        this.whitespaceHelper = whitespaceHelper;
        this.existingImports = importManager.getImports();
    }

    public String toString() {
        return this.getCode();
    }

    public int getTotalOffset() {
        return this.whitespaceHelper.getTotalOffset();
    }

    public String getCode() {
        StringBuilder b = new StringBuilder();
        if (this.whitespaceHelper.getPrefix() != null) {
            b.append(this.whitespaceHelper.getPrefix().replace("\n", this.getIndentationString()));
        }
        b.append(super.toString());
        if (this.whitespaceHelper.getSuffix() != null) {
            b.append(this.whitespaceHelper.getSuffix().replace("\n", this.getIndentationString()));
        }
        return b.toString();
    }

    public void commitChanges() throws BadLocationException {
        this.document.replace(this.whitespaceHelper.getTotalOffset(), this.whitespaceHelper.getTotalLength(), this.toString());
        this.insertNewImports();
    }

    public int commitChanges(int offset, int length) throws BadLocationException {
        int actualOffset = Math.min(this.whitespaceHelper.getTotalOffset(), offset);
        int endOffset = Math.max(this.whitespaceHelper.getTotalOffset() + this.whitespaceHelper.getTotalLength(), offset + length);
        int actualLength = endOffset - actualOffset;
        this.document.replace(actualOffset, actualLength, this.toString());
        int shiftCursorBy = this.insertNewImports();
        return shiftCursorBy;
    }

    public int insertNewImports() throws BadLocationException {
        List<String> newImports = this.getNewImports();
        if (!newImports.isEmpty()) {
            int offset;
            StringBuilder importSection = new StringBuilder();
            for (String newImport : newImports) {
                importSection.append("import ");
                importSection.append(newImport);
                importSection.append("\n");
            }
            if (this.xtendFile.getImports().isEmpty()) {
                offset = NodeModelUtils.findActualNodeFor((EObject)this.xtendFile.getXtendClass()).getOffset();
                importSection.append("\n");
            } else {
                ICompositeNode lastImportNode = NodeModelUtils.findActualNodeFor((EObject)((EObject)this.xtendFile.getImports().get(this.xtendFile.getImports().size() - 1)));
                importSection.insert(0, "\n");
                importSection.replace(importSection.length() - 1, importSection.length(), "");
                offset = lastImportNode.getOffset() + lastImportNode.getLength();
            }
            this.document.replace(offset, 0, importSection.toString());
            return importSection.length();
        }
        return 0;
    }

    protected List<String> getNewImports() {
        List imports = this.getImportManager().getImports();
        imports.removeAll(this.existingImports);
        return imports;
    }

    public static class Factory {
        @Inject
        private IIndentationInformation indentation;
        @Inject
        private XbaseScopeProvider scopeProvider;
        @Inject
        private IQualifiedNameConverter converter;
        @Inject
        private IXtend2JvmAssociations associations;
        @Inject
        private Provider<WhitespaceHelper> whitespaceHelperProvider;

        public ReplacingAppendable get(IXtextDocument document, EObject context, int offset, int length) {
            return this.get(document, context, offset, length, this.getIndentationLevelAtOffset(offset, (IDocument)document), false);
        }

        public ReplacingAppendable get(IXtextDocument document, EObject context, int offset, int length, int indentationLevel, boolean ensureEmptyLinesAround) {
            try {
                XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)context, XtendFile.class);
                if (xtendFile != null) {
                    ImportManager importManager = new ImportManager(true);
                    for (XtendImport xImport : xtendFile.getImports()) {
                        if (xImport.getImportedType() == null) continue;
                        importManager.addImportFor(xImport.getImportedType());
                    }
                    WhitespaceHelper whitespaceHelper = (WhitespaceHelper)this.whitespaceHelperProvider.get();
                    whitespaceHelper.initialize((IDocument)document, offset, length, ensureEmptyLinesAround);
                    ReplacingAppendable appendable = new ReplacingAppendable(importManager, this.indentation.getIndentString(), document, xtendFile, whitespaceHelper);
                    IScope scope = this.scopeProvider.createSimpleFeatureCallScope(this.getLocalVariableScopeContext(context), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, context.eResource(), true, -1);
                    for (IEObjectDescription feature : scope.getAllElements()) {
                        if (!(feature instanceof IValidatedEObjectDescription) || !((IValidatedEObjectDescription)feature).isVisible()) continue;
                        appendable.declareVariable(feature, this.converter.toString(feature.getName()));
                    }
                    int i = 0;
                    while (i < indentationLevel) {
                        appendable.increaseIndentation();
                        ++i;
                    }
                    return appendable;
                }
            }
            catch (Exception exc) {
                LOG.error((Object)"Error initializing appendable", (Throwable)exc);
            }
            return null;
        }

        protected EObject getLocalVariableScopeContext(EObject context) {
            if (context instanceof XtendClass) {
                return this.associations.getInferredType((XtendClass)context);
            }
            if (context instanceof XtendFunction) {
                return this.associations.getDirectlyInferredOperation((XtendFunction)context);
            }
            return context;
        }

        protected int getIndentationLevelAtOffset(int offset, IDocument document) {
            block4: {
                if (offset > 0) break block4;
                return 0;
            }
            try {
                int currentOffset = offset - 1;
                char currentChr = document.getChar(currentOffset);
                int indentationOffset = 0;
                while (currentChr != '\n' && currentChr != '\r' && currentOffset > 0) {
                    indentationOffset = Character.isWhitespace(currentChr) ? ++indentationOffset : 0;
                    currentChr = document.getChar(--currentOffset);
                }
                return indentationOffset / this.indentation.getIndentString().length();
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error calculating indentation at offset", (Throwable)e);
                return 0;
            }
        }
    }
}

