/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.inject.Injector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.parser.antlr.AbstractAntlrGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.debug.SimpleAntlrStandaloneSetup;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.StringInputStream;

public class DebugAntlrGeneratorFragment
extends AbstractAntlrGeneratorFragment {
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        issues.addInfo("Generate debugging grammar file");
    }

    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        String srcGenPath = ctx.getOutput().getOutlet("SRC_GEN").getPath();
        String absoluteGrammarFileName = String.valueOf(srcGenPath) + "/" + this.getGrammarFileName(grammar, this.getNaming()).replace('.', '/') + ".g";
        this.prettyPrint(absoluteGrammarFileName);
    }

    protected void prettyPrint(String absoluteGrammarFileName) {
        try {
            String content = Files.readFileIntoString((String)absoluteGrammarFileName);
            Injector injector = new SimpleAntlrStandaloneSetup().createInjectorAndDoEMFRegistration();
            XtextResource resource = (XtextResource)injector.getInstance(XtextResource.class);
            resource.load((InputStream)new StringInputStream(content), null);
            if (!resource.getErrors().isEmpty()) {
                throw new RuntimeException(resource.getErrors().toString());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(content.length());
            resource.save((OutputStream)outputStream, SaveOptions.newBuilder().format().getOptions().toOptionsMap());
            Files.writeStringIntoFile((String)absoluteGrammarFileName, (String)outputStream.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getGrammarFileName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageRuntime(g)) + ".parser.antlr.internal.DebugInternal" + GrammarUtil.getName((Grammar)g);
    }
}

