/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.matching;

import org.eclipse.xtext.parser.packrat.ICharSequenceWithOffset;
import org.eclipse.xtext.parser.packrat.IMarkerFactory;
import org.eclipse.xtext.util.Strings;

public class StringWithOffset
implements ICharSequenceWithOffset,
IMarkerFactory {
    private final String value;
    private int offset;

    public StringWithOffset(String value) {
        this.value = Strings.emptyIfNull((String)value);
        this.offset = 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void incOffset() {
        ++this.offset;
    }

    public void incOffset(int amount) {
        this.offset += amount;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public int length() {
        return this.value.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public IMarkerFactory.IMarker mark() {
        return new Marker();
    }

    private class Marker
    implements IMarkerFactory.IMarker {
        private int offset;

        public Marker() {
            this(stringWithOffset.offset);
        }

        private Marker(int offset) {
            this.offset = offset;
        }

        public void rollback() {
            StringWithOffset.this.setOffset(this.offset);
        }

        public String toString() {
            return "Marker@" + this.offset;
        }

        public void commit() {
        }

        public IMarkerFactory.IMarker fork() {
            return new Marker(this.offset);
        }

        public IMarkerFactory.IMarker join(IMarkerFactory.IMarker forkedMarker) {
            return this;
        }

        public void flush() {
        }
    }
}

