/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.JdtProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;

@Singleton
public class EclipseProjectConfigProvider
implements IProjectConfigProvider {
    @Inject
    private IJdtHelper jdtHelper;

    public IProjectConfig getProjectConfig(ResourceSet context) {
        ProjectConfigAdapter projectConfigAdapter = ProjectConfigAdapter.findInEmfObject((Notifier)context);
        return projectConfigAdapter != null ? projectConfigAdapter.getProjectConfig() : null;
    }

    public void installProjectConfig(IProject eclipseProject, ResourceSet resourceSet) {
        EclipseProjectConfig config = this.createProjectConfig(eclipseProject);
        ProjectConfigAdapter.install((ResourceSet)resourceSet, (IProjectConfig)config);
    }

    public EclipseProjectConfig createProjectConfig(IProject eclipseProject) {
        if (this.jdtHelper.isJavaCoreAvailable()) {
            return new JdtProjectConfig(eclipseProject, this);
        }
        return new EclipseProjectConfig(eclipseProject, this);
    }
}

