/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.arguments;

import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ReorderedFeatureCallArguments
extends StandardFeatureCallArguments {
    protected final List<XExpression> shiftedArguments;
    protected final List<JvmFormalParameter> shiftedParameters;

    public ReorderedFeatureCallArguments(List<XExpression> arguments, List<JvmFormalParameter> parameters, List<XExpression> shiftedArguments, List<JvmFormalParameter> shiftedParameters, boolean hasReceiver, OwnedConverter converter) {
        super(arguments, parameters, hasReceiver, converter);
        this.shiftedArguments = shiftedArguments;
        this.shiftedParameters = shiftedParameters;
    }

    @Override
    public boolean hasUnprocessedArguments() {
        return this.nextUnprocessedArgument < this.arguments.size() + this.shiftedArguments.size();
    }

    @Override
    public IFeatureCallArgumentSlot getNextUnprocessedArgumentSlot() {
        if (!this.hasUnprocessedArguments()) {
            throw new NoSuchElementException();
        }
        if (this.nextUnprocessedArgument >= this.parameters.size() && this.nextUnprocessedArgument - this.parameters.size() < this.shiftedParameters.size()) {
            return new StandardFeatureCallArgumentSlot(this, this.nextUnprocessedArgument);
        }
        return super.getNextUnprocessedArgumentSlot();
    }

    @Override
    public int getArgumentCount() {
        return super.getArgumentCount() + this.shiftedArguments.size();
    }

    @Override
    public XExpression internalGetArgument(int idx) {
        if (idx >= this.parameters.size()) {
            if (idx >= this.shiftedParameters.size() + this.parameters.size()) {
                return (XExpression)this.arguments.get(idx - this.shiftedParameters.size());
            }
            return this.shiftedArguments.get(idx - this.parameters.size());
        }
        return (XExpression)this.arguments.get(idx);
    }

    @Override
    @Nullable
    protected LightweightTypeReference internalGetParameterType(int idx) {
        if (idx >= this.parameters.size()) {
            JvmFormalParameter parameter = this.shiftedParameters.get(idx - this.parameters.size());
            return this.toLightweightTypeReference(parameter);
        }
        JvmFormalParameter parameter = (JvmFormalParameter)this.parameters.get(idx);
        return this.toLightweightTypeReference(parameter);
    }
}

