/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySimpleMemberSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeArgumentSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.impl.JvmTypeConstraintImplCustom;
import org.objectweb.asm.Type;

class Proxies {
    protected static final String JAVA_LANG_OBJECT = "java/lang/Object";
    protected final Map<BinaryTypeSignature, JvmType> typeProxies = new HashMap<BinaryTypeSignature, JvmType>();
    protected final Map<BinarySimpleMemberSignature, JvmOperation> operationProxies = new HashMap<BinarySimpleMemberSignature, JvmOperation>();

    Proxies() {
    }

    protected JvmOperation createMethodProxy(BinaryTypeSignature type, String methodName) {
        BinarySimpleMemberSignature method = type.appendMethod(methodName);
        JvmOperation proxy = this.operationProxies.get(method);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmOperation();
            URI uri = method.getURI();
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.operationProxies.put(method, proxy);
        }
        return proxy;
    }

    public JvmTypeReference createTypeReference(BinaryTypeSignature type, Map<String, JvmTypeParameter> typeParameters) {
        int arrayCount = type.getArrayDimensions();
        if (arrayCount > 0) {
            BinaryTypeSignature elementType = type.getArrayComponentType();
            JvmTypeReference result = this.createTypeReference(elementType, typeParameters);
            int i = 0;
            while (i < arrayCount) {
                JvmGenericArrayTypeReference array = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
                array.setComponentType(result);
                result = array;
                ++i;
            }
            return result;
        }
        BinaryTypeSignature outer = type.getOuter();
        JvmParameterizedTypeReference result = null;
        if (outer == null) {
            result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        } else {
            JvmParameterizedTypeReference outerReference = (JvmParameterizedTypeReference)this.createTypeReference(outer, typeParameters);
            result = TypesFactory.eINSTANCE.createJvmInnerTypeReference();
            ((JvmInnerTypeReference)result).setOuter(outerReference);
        }
        result.setType(this.createProxy(type.getTypeErasure(), typeParameters));
        List<BinaryTypeArgumentSignature> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == 0) {
            return result;
        }
        InternalEList arguments = (InternalEList)result.getArguments();
        int i = 0;
        while (i < typeArguments.size()) {
            JvmTypeReference argument = this.createTypeArgument(typeArguments.get(i), typeParameters);
            arguments.addUnique((Object)argument);
            ++i;
        }
        return result;
    }

    public JvmTypeReference createTypeArgument(BinaryTypeArgumentSignature actualTypeArgument, Map<String, JvmTypeParameter> typeParameters) {
        if (actualTypeArgument.isWildcard()) {
            JvmWildcardTypeReference result = TypesFactory.eINSTANCE.createJvmWildcardTypeReference();
            InternalEList constraints = (InternalEList)result.getConstraints();
            BinaryGenericTypeSignature upperBound = actualTypeArgument.getUpperBound();
            if (upperBound != null) {
                jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                JvmTypeReference upperBoundType = this.createTypeReference(upperBound, typeParameters);
                ((JvmTypeConstraintImplCustom)((Object)jvmUpperBound)).internalSetTypeReference(upperBoundType);
                constraints.addUnique((Object)jvmUpperBound);
            } else {
                jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                ((JvmTypeConstraintImplCustom)((Object)jvmUpperBound)).internalSetTypeReference(this.createObjectTypeReference());
                constraints.addUnique((Object)jvmUpperBound);
            }
            BinaryGenericTypeSignature lowerBound = actualTypeArgument.getLowerBound();
            if (lowerBound != null) {
                JvmLowerBound jvmLowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                JvmTypeReference boundType = this.createTypeReference(lowerBound, typeParameters);
                ((JvmTypeConstraintImplCustom)((Object)jvmLowerBound)).internalSetTypeReference(boundType);
                constraints.addUnique((Object)jvmLowerBound);
            }
            return result;
        }
        return this.createTypeReference(actualTypeArgument, typeParameters);
    }

    public JvmTypeReference createObjectTypeReference() {
        return this.createTypeReference(BinarySignatures.createObjectTypeSignature(JAVA_LANG_OBJECT), null);
    }

    public JvmType createProxy(BinaryTypeSignature type, Map<String, JvmTypeParameter> typeParameters) {
        String variableName = type.getTypeVariableName();
        if (variableName != null) {
            if (typeParameters == null) {
                throw new IllegalStateException(type.toString());
            }
            JvmType result = typeParameters.get(variableName);
            if (result == null) {
                throw new IllegalStateException(type.toString());
            }
            return result;
        }
        JvmType proxy = this.typeProxies.get(type);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmVoid();
            URI uri = type.getURI();
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.typeProxies.put(type, proxy);
        }
        return proxy;
    }

    public JvmAnnotationType createAnnotationProxy(BinaryTypeSignature type) {
        JvmType proxy = this.typeProxies.get(type);
        if (proxy == null) {
            JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
            URI uri = type.getURI();
            ((InternalEObject)result).eSetProxyURI(uri);
            this.typeProxies.put(type, result);
            return result;
        }
        if (proxy.eClass() != TypesPackage.Literals.JVM_ANNOTATION_TYPE) {
            JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
            ((InternalEObject)result).eSetProxyURI(((InternalEObject)proxy).eProxyURI());
            this.typeProxies.put(type, result);
            return result;
        }
        return (JvmAnnotationType)proxy;
    }

    public JvmAnnotationValue createAnnotationValue(Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Byte.class) {
            JvmByteAnnotationValue result = TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Byte)value));
            return result;
        }
        if (valueClass == Boolean.class) {
            JvmBooleanAnnotationValue result = TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Boolean)value));
            return result;
        }
        if (valueClass == Character.class) {
            JvmCharAnnotationValue result = TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Character)value));
            return result;
        }
        if (valueClass == Short.class) {
            JvmShortAnnotationValue result = TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Short)value));
            return result;
        }
        if (valueClass == Integer.class) {
            JvmIntAnnotationValue result = TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Integer)value));
            return result;
        }
        if (valueClass == Long.class) {
            JvmLongAnnotationValue result = TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Long)value));
            return result;
        }
        if (valueClass == Float.class) {
            JvmFloatAnnotationValue result = TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Float)value));
            return result;
        }
        if (valueClass == Double.class) {
            JvmDoubleAnnotationValue result = TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((Double)value));
            return result;
        }
        if (valueClass == String.class) {
            JvmStringAnnotationValue result = TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
            ((InternalEList)result.getValues()).addUnique((Object)((String)value));
            return result;
        }
        if (valueClass == Type.class) {
            BinaryTypeSignature signature;
            JvmTypeAnnotationValue result = TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
            Type type = (Type)value;
            if (type.getSort() == 10) {
                String typeName = type.getInternalName();
                signature = BinarySignatures.createObjectTypeSignature(typeName);
            } else {
                String typeName = type.getDescriptor();
                signature = BinarySignatures.createTypeSignature(typeName);
            }
            ((InternalEList)result.getValues()).addUnique((Object)this.createTypeReference(signature, null));
            return result;
        }
        String className = valueClass.getName();
        if (className.startsWith("[") && className.length() == 2) {
            switch (className.charAt(1)) {
                case 'Z': {
                    boolean[] booleanValues;
                    JvmBooleanAnnotationValue result = TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
                    boolean[] blArray = booleanValues = (boolean[])value;
                    int n = booleanValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean b = blArray[n2];
                        ((InternalEList)result.getValues()).addUnique((Object)b);
                        ++n2;
                    }
                    return result;
                }
                case 'C': {
                    char[] charValues;
                    JvmCharAnnotationValue result = TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
                    char[] cArray = charValues = (char[])value;
                    int n = charValues.length;
                    int n3 = 0;
                    while (n3 < n) {
                        char c = cArray[n3];
                        ((InternalEList)result.getValues()).addUnique((Object)Character.valueOf(c));
                        ++n3;
                    }
                    return result;
                }
                case 'B': {
                    byte[] byteValues;
                    JvmByteAnnotationValue result = TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
                    byte[] byArray = byteValues = (byte[])value;
                    int n = byteValues.length;
                    int n4 = 0;
                    while (n4 < n) {
                        byte b = byArray[n4];
                        ((InternalEList)result.getValues()).addUnique((Object)b);
                        ++n4;
                    }
                    return result;
                }
                case 'S': {
                    short[] shortValues;
                    JvmShortAnnotationValue result = TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
                    short[] sArray = shortValues = (short[])value;
                    int n = shortValues.length;
                    int n5 = 0;
                    while (n5 < n) {
                        short s = sArray[n5];
                        ((InternalEList)result.getValues()).addUnique((Object)s);
                        ++n5;
                    }
                    return result;
                }
                case 'I': {
                    int[] intValues;
                    JvmIntAnnotationValue result = TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
                    int[] nArray = intValues = (int[])value;
                    int n = intValues.length;
                    int n6 = 0;
                    while (n6 < n) {
                        int i = nArray[n6];
                        ((InternalEList)result.getValues()).addUnique((Object)i);
                        ++n6;
                    }
                    return result;
                }
                case 'F': {
                    float[] floatValues;
                    JvmFloatAnnotationValue result = TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
                    float[] fArray = floatValues = (float[])value;
                    int n = floatValues.length;
                    int n7 = 0;
                    while (n7 < n) {
                        float f = fArray[n7];
                        ((InternalEList)result.getValues()).addUnique((Object)Float.valueOf(f));
                        ++n7;
                    }
                    return result;
                }
                case 'J': {
                    long[] longValues;
                    JvmLongAnnotationValue result = TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
                    long[] lArray = longValues = (long[])value;
                    int n = longValues.length;
                    int n8 = 0;
                    while (n8 < n) {
                        long l = lArray[n8];
                        ((InternalEList)result.getValues()).addUnique((Object)l);
                        ++n8;
                    }
                    return result;
                }
                case 'D': {
                    double[] doubleValues;
                    JvmDoubleAnnotationValue result = TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
                    double[] dArray = doubleValues = (double[])value;
                    int n = doubleValues.length;
                    int n9 = 0;
                    while (n9 < n) {
                        double d = dArray[n9];
                        ((InternalEList)result.getValues()).addUnique((Object)d);
                        ++n9;
                    }
                    return result;
                }
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public JvmEnumerationLiteral createEnumLiteral(String literalName, String typeName) {
        return this.createEnumLiteral(literalName, BinarySignatures.createObjectTypeSignature(typeName));
    }

    protected JvmEnumerationLiteral createEnumLiteral(String literalName, BinaryTypeSignature typeName) {
        JvmEnumerationLiteral enumLiteralProxy = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        InternalEObject internalEObject = (InternalEObject)enumLiteralProxy;
        BinarySimpleMemberSignature fieldSignature = typeName.appendField(literalName);
        URI uri = fieldSignature.getURI();
        internalEObject.eSetProxyURI(uri);
        return enumLiteralProxy;
    }

    public Map<String, JvmTypeParameter> createTypeParameters(AbstractBinarySignature signature, JvmTypeParameterDeclarator container, Map<String, JvmTypeParameter> knownTypeParameters) {
        List<BinaryTypeParameter> typeParameters = signature.getTypeParameters();
        if (typeParameters.size() != 0) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)((knownTypeParameters != null ? knownTypeParameters.size() : 0) + typeParameters.size()));
            if (knownTypeParameters != null) {
                result.putAll(knownTypeParameters);
            }
            InternalEList jvmTypeParameters = (InternalEList)container.getTypeParameters();
            int i = 0;
            while (i < typeParameters.size()) {
                JvmTypeParameter typeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
                String name = typeParameters.get(i).getName();
                typeParameter.setName(name);
                jvmTypeParameters.addUnique((Object)typeParameter);
                result.put(name, typeParameter);
                ++i;
            }
            i = 0;
            while (i < typeParameters.size()) {
                List<BinaryGenericTypeSignature> bounds = typeParameters.get(i).getBounds();
                JvmTypeParameter typeParameter = (JvmTypeParameter)jvmTypeParameters.get(i);
                InternalEList constraints = (InternalEList)typeParameter.getConstraints();
                int j = 0;
                while (j < bounds.size()) {
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(this.createTypeReference(bounds.get(j), result));
                    constraints.addUnique((Object)upperBound);
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return knownTypeParameters;
    }

    public void setVisibility(int accessFlags, JvmMember result) {
        switch (accessFlags & 7) {
            case 2: {
                result.setVisibility(JvmVisibility.PRIVATE);
                return;
            }
            case 4: {
                result.setVisibility(JvmVisibility.PROTECTED);
                return;
            }
            case 1: {
                result.setVisibility(JvmVisibility.PUBLIC);
                return;
            }
        }
        result.setVisibility(JvmVisibility.DEFAULT);
    }
}

