/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.detachable.ArrayReference;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.NodeModelOutput;

public class CompactStoredNodeModelWriter
extends BinaryResourceImpl.EObjectOutputStream
implements NodeModelOutput {
    private final Tabulated<ArrayReference> grammarElementArrays;
    private final Tabulated<EObject> semanticObjects;
    private final Tabulated<SyntaxErrorMessage> syntaxErrorMessages;
    private final GrammarElementLookup grammarElements;

    public CompactStoredNodeModelWriter(OutputStream out, Tabulated<EObject> semanticObjects, GrammarElementLookup grammarElements) throws IOException {
        super(out, Collections.singletonMap("INTERNAL_BUFFER_CAPACITY", 8192), BinaryResourceImpl.BinaryIO.Version.VERSION_1_1, 16);
        this.grammarElements = grammarElements;
        this.syntaxErrorMessages = new Tabulated();
        this.grammarElementArrays = new Tabulated();
        this.semanticObjects = semanticObjects;
    }

    protected void writeSignature() throws IOException {
    }

    @Override
    public void writeGrammarElement(Object grammarElementOrArray) throws IOException {
        if (grammarElementOrArray != null) {
            if (grammarElementOrArray instanceof EObject) {
                this.writeCompressedInt(this.grammarElements.getId((EObject)grammarElementOrArray));
            } else {
                int prevSize = this.grammarElementArrays.size();
                EObject[] array = (EObject[])grammarElementOrArray;
                int arrayId = this.grammarElementArrays.getId(new ArrayReference(array));
                this.writeCompressedInt(this.grammarElements.size() + arrayId);
                if (prevSize == arrayId) {
                    this.writeCompressedInt(array.length);
                    EObject[] eObjectArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EObject element = eObjectArray[n2];
                        this.writeCompressedInt(this.grammarElements.getId(element));
                        ++n2;
                    }
                }
            }
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeSemanticObject(EObject semanticElement) throws IOException {
        if (semanticElement != null) {
            this.writeCompressedInt(this.semanticObjects.getId(semanticElement));
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeSyntaxErrorMessage(SyntaxErrorMessage syntaxErrorMessage) throws IOException {
        if (syntaxErrorMessage != null) {
            int prevSize = this.syntaxErrorMessages.size();
            int messageId = this.syntaxErrorMessages.getId(syntaxErrorMessage);
            this.writeCompressedInt(messageId);
            if (prevSize == messageId) {
                this.writeSegmentedString(syntaxErrorMessage.getIssueCode());
                this.writeSegmentedString(syntaxErrorMessage.getMessage());
                String[] issueData = syntaxErrorMessage.getIssueData();
                if (issueData == null) {
                    this.writeCompressedInt(-1);
                } else {
                    this.writeCompressedInt(issueData.length);
                    String[] stringArray = issueData;
                    int n = issueData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        this.writeSegmentedString(s);
                        ++n2;
                    }
                }
            }
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeContent(String value) throws IOException {
    }
}

