/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor.actions;

import com.google.inject.Inject;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.folding.FoldingActionContributor;
import org.eclipse.xtext.ui.editor.folding.FoldingActionGroup;
import org.eclipse.xtext.ui.editor.folding.FoldingMessages;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

public class XbaseFoldingActionContributor
extends FoldingActionContributor {
    @Inject
    private IPreferenceStoreAccess storeAccess;

    public void contributeActions(XtextEditor xtextEditor) {
        this.foldingActionGroup = new FoldingActionGroup((ITextEditor)xtextEditor, (ITextViewer)xtextEditor.getInternalSourceViewer()){

            protected TextEditorAction createToggleFoldingAction(ITextEditor editor) {
                ResourceActionExtension toggle = new ResourceActionExtension(FoldingMessages.getResourceBundle(), "Projection.Toggle.", editor, 19);
                toggle.setChecked(true);
                toggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
                return toggle;
            }
        };
    }

    private final class ResourceActionExtension
    extends TextEditorAction {
        private ResourceActionExtension(ResourceBundle bundle, String prefix, ITextEditor editor, int style) {
            super(bundle, prefix, editor, style);
        }

        public void run() {
            boolean currentstate = this.currentPreferenceStoreState();
            PreferenceConstants.getPreferenceStore().setValue("editor_folding_enabled", !currentstate);
        }

        private boolean currentPreferenceStoreState() {
            return XbaseFoldingActionContributor.this.storeAccess.getPreferenceStore().getBoolean("editor_folding_enabled");
        }

        public void update() {
            ITextOperationTarget target = (ITextOperationTarget)Adapters.adapt((Object)this.getTextEditor(), ITextOperationTarget.class);
            boolean isEnabled = target instanceof ProjectionViewer;
            this.setEnabled(isEnabled);
        }
    }
}

