/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.DocumentRegionValidator;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.Messages;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;

public class ResourceMarkerMarkupValidator
extends DocumentRegionValidator {
    @Override
    protected void clearProblems(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        monitor.beginTask(Messages.ResourceMarkerMarkupValidator_clearingMarkers, 1);
        monitor.done();
    }

    @Override
    protected void createProblems(IProgressMonitor monitor, IDocument document, IRegion region, List<ValidationProblem> problems) throws CoreException {
        IMarker[] iMarkerArray;
        int findMarkersWorkSize = 100;
        int zeroProblemsStep = 10;
        monitor.beginTask(Messages.ResourceMarkerMarkupValidator_creatingMarkers, problems.size() + 100 + 10);
        ArrayList<Object> markersInRegion = new ArrayList<Object>(5);
        HashMap<Integer, Object> markerByOffset = new HashMap<Integer, Object>();
        IMarker[] iMarkerArray2 = iMarkerArray = this.resource.findMarkers("org.eclipse.mylyn.wikitext.ui.validation.problem", true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            Object marker = iMarkerArray2[n2];
            int offset = marker.getAttribute("charStart", 0);
            if (this.overlaps(region, offset, (end = marker.getAttribute("charEnd", offset)) - offset) || offset >= document.getLength()) {
                markersInRegion.add(marker);
                markerByOffset.put(offset, marker);
            }
            ++n2;
        }
        monitor.worked(100);
        if (problems.isEmpty()) {
            for (IMarker iMarker : markersInRegion) {
                iMarker.delete();
            }
            monitor.worked(10);
            monitor.done();
            return;
        }
        monitor.worked(10);
        if (!markersInRegion.isEmpty()) {
            Iterator<ValidationProblem> iterator = problems.iterator();
            while (iterator.hasNext()) {
                ValidationProblem problem = iterator.next();
                IMarker marker = (IMarker)markerByOffset.get(problem.getOffset());
                if (marker == null) continue;
                int charEnd = marker.getAttribute("charEnd", -1);
                if (problem.getOffset() + problem.getLength() != charEnd || this.toMarkerSeverity(problem.getSeverity()) != marker.getAttribute("severity", -1) || !problem.getMessage().equals(marker.getAttribute("message", ""))) continue;
                iterator.remove();
                markerByOffset.remove(problem.getOffset());
                markersInRegion.remove(marker);
                monitor.worked(1);
            }
            for (Object marker : markersInRegion) {
                marker.delete();
            }
        }
        for (ValidationProblem validationProblem : problems) {
            IMarker marker = this.resource.createMarker(validationProblem.getMarkerId());
            marker.setAttribute("transient", true);
            marker.setAttribute("severity", this.toMarkerSeverity(validationProblem.getSeverity()));
            marker.setAttribute("message", (Object)validationProblem.getMessage());
            marker.setAttribute("charStart", validationProblem.getOffset());
            marker.setAttribute("charEnd", validationProblem.getOffset() + validationProblem.getLength());
            try {
                int line = document.getLineOfOffset(validationProblem.getOffset());
                marker.setAttribute("lineNumber", line + 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private int toMarkerSeverity(ValidationProblem.Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
        }
        throw new IllegalStateException(severity.name());
    }
}

