/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.ncx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OverrideType implements Enumerator
{
    VISIBLE(0, "visible", "visible"),
    HIDDEN(1, "hidden", "hidden");

    public static final int VISIBLE_VALUE = 0;
    public static final int HIDDEN_VALUE = 1;
    private static final OverrideType[] VALUES_ARRAY;
    public static final List<OverrideType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static OverrideType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OverrideType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static OverrideType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OverrideType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static OverrideType get(int value) {
        switch (value) {
            case 0: {
                return VISIBLE;
            }
            case 1: {
                return HIDDEN;
            }
        }
        return null;
    }

    private OverrideType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new OverrideType[]{VISIBLE, HIDDEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

