/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup.block;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public abstract class GlossaryBlock
extends Block {
    protected int blockLineNumber = 0;
    private String style;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        if (!this.getMarkupLanguage().isFilterGenerativeContents()) {
            TreeMap<String, String> glossary = new TreeMap<String, String>(this.state.getGlossaryTerms());
            this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, new Attributes(null, null, this.style == null ? null : "list-style: " + this.style, null));
            Attributes nullAttributes = new Attributes();
            for (Map.Entry ent : glossary.entrySet()) {
                this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, nullAttributes);
                this.builder.characters((String)ent.getKey());
                this.builder.endBlock();
                this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, nullAttributes);
                this.builder.characters((String)ent.getValue());
                this.builder.endBlock();
            }
            this.builder.endBlock();
        }
        return -1;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed) {
            this.style = null;
        }
        super.setClosed(closed);
    }
}

