/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.htmltext.configuration;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class ConfigurationElement {
    private String ckConfigElement;
    protected Object value;

    protected ConfigurationElement(String ckConfigElement, Object value) {
        this.ckConfigElement = ckConfigElement;
        this.value = value;
    }

    public String getCkConfigElement() {
        return this.ckConfigElement;
    }

    protected abstract Object doGetDefaultValue();

    public final Object getDefaultValue() {
        return this.doGetDefaultValue();
    }

    public String toQuery() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null && !this.value.equals(this.getDefaultValue())) {
            try {
                String valueForEditor = URLEncoder.encode(this.getValueForEditor(), "UTF-8");
                if (valueForEditor != null) {
                    sb.append(this.ckConfigElement).append("=").append(valueForEditor);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return sb.toString();
    }

    public String getValueForEditor() {
        return this.value == null ? null : this.value.toString();
    }
}

