/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;

class LookAheadLineSequence
extends LineSequence {
    private final LineSequence.ForwardLineSequence lineSequence;
    private Line currentLine;
    private final Line referenceLine;
    private int index;

    public LookAheadLineSequence(LineSequence.ForwardLineSequence lineSequence) {
        this.lineSequence = lineSequence;
        this.referenceLine = this.currentLine = lineSequence.getCurrentLine();
        this.index = -1;
    }

    public LookAheadLineSequence(LookAheadLineSequence lookAheadLineSequence) {
        this.lineSequence = lookAheadLineSequence.lineSequence;
        this.currentLine = lookAheadLineSequence.currentLine;
        this.referenceLine = lookAheadLineSequence.referenceLine;
        this.index = lookAheadLineSequence.index;
    }

    @Override
    public Line getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public Line getNextLine() {
        this.checkConcurrentModification();
        return this.lineSequence.getNextLine(this.index + 1);
    }

    @Override
    public void advance() {
        this.checkConcurrentModification();
        this.currentLine = this.getNextLine();
        ++this.index;
    }

    private void checkConcurrentModification() {
        Preconditions.checkState((this.referenceLine == this.lineSequence.getCurrentLine() ? 1 : 0) != 0);
    }

    @Override
    public LineSequence lookAhead() {
        return new LookAheadLineSequence(this);
    }
}

