/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;

public class TypeSystem {
    private int typeid = 128;
    private TypeBinding[][] types;
    private SimpleLookupTable annotationTypes;
    private LookupEnvironment environment;

    public TypeSystem(LookupEnvironment environment) {
        this.environment = environment;
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
    }

    public final TypeBinding getUnannotatedType(TypeBinding type) {
        if (type.isUnresolvedType() && CharOperation.indexOf('$', type.sourceName()) > 0) {
            type = BinaryTypeBinding.resolveType(type, this.environment, true);
        }
        if (type.id == Integer.MAX_VALUE) {
            if (type.hasTypeAnnotations()) {
                throw new IllegalStateException();
            }
            int typesLength = this.types.length;
            if (this.typeid == typesLength) {
                this.types = new TypeBinding[typesLength * 2][];
                System.arraycopy(this.types, 0, this.types, 0, typesLength);
            }
            type.id = this.typeid++;
            this.types[type.id] = new TypeBinding[4];
        } else {
            TypeBinding nakedType;
            TypeBinding typeBinding = nakedType = this.types[type.id] == null ? null : this.types[type.id][0];
            if (type.hasTypeAnnotations() && nakedType == null) {
                throw new IllegalStateException();
            }
            if (nakedType != null) {
                return nakedType;
            }
            this.types[type.id] = new TypeBinding[4];
        }
        TypeBinding typeBinding = type;
        this.types[type.id][0] = typeBinding;
        return typeBinding;
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding type) {
        return Binding.NO_TYPES;
    }

    public ArrayBinding getArrayType(TypeBinding leafType, int dimensions) {
        TypeBinding unannotatedLeafType = this.getUnannotatedType(leafType);
        TypeBinding[] derivedTypes = this.types[unannotatedLeafType.id];
        int length = derivedTypes.length;
        int i = 0;
        while (i < length) {
            TypeBinding derivedType = derivedTypes[i];
            if (derivedType == null) break;
            if (derivedType.isArrayType() && !derivedType.hasTypeAnnotations() && derivedType.leafComponentType() == unannotatedLeafType && derivedType.dimensions() == dimensions) {
                return (ArrayBinding)derivedType;
            }
            ++i;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedLeafType.id] = derivedTypes;
        }
        derivedTypes[i] = new ArrayBinding(unannotatedLeafType, dimensions, this.environment);
        ArrayBinding arrayType = derivedTypes[i];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        arrayType.id = this.typeid++;
        ArrayBinding arrayBinding = arrayType;
        this.types[arrayType.id][0] = arrayBinding;
        return arrayBinding;
    }

    public ArrayBinding getArrayType(TypeBinding leafComponentType, int dimensions, AnnotationBinding[] annotations) {
        return this.getArrayType(leafComponentType, dimensions);
    }

    public ReferenceBinding getMemberType(ReferenceBinding memberType, ReferenceBinding enclosingType) {
        return memberType;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ReferenceBinding enclosingType) {
        return this.getParameterizedType(genericType, typeArguments, null, -1, enclosingType);
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ITeamAnchor teamAnchor, int valueParamPosition, ReferenceBinding enclosingType) {
        if (teamAnchor == null && genericType instanceof DependentTypeBinding) {
            teamAnchor = ((DependentTypeBinding)genericType)._teamAnchor;
        }
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        int typeArgumentsLength = typeArguments == null ? 0 : typeArguments.length;
        Object[] unannotatedTypeArguments = typeArguments == null ? null : new TypeBinding[typeArgumentsLength];
        int i = 0;
        while (i < typeArgumentsLength) {
            unannotatedTypeArguments[i] = this.getUnannotatedType(typeArguments[i]);
            ++i;
        }
        ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)this.getUnannotatedType(enclosingType);
        TypeBinding[] derivedTypes = this.types[unannotatedGenericType.id];
        int length = derivedTypes.length;
        int i2 = 0;
        while (i2 < length) {
            TypeBinding derivedType = derivedTypes[i2];
            if (derivedType == null) break;
            if (derivedType instanceof ParameterizedTypeBinding && derivedType.actualType() == unannotatedGenericType && (!derivedType.isRawType() || unannotatedTypeArguments == null) && this.isRoleTypeMatch(teamAnchor, valueParamPosition, derivedType) && derivedType.enclosingType() == unannotatedEnclosingType && Util.effectivelyEqual(derivedType.typeArguments(), unannotatedTypeArguments)) {
                return (ParameterizedTypeBinding)derivedType;
            }
            ++i2;
        }
        if (i2 == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedGenericType.id] = derivedTypes;
        }
        ParameterizedTypeBinding parameterizedType = teamAnchor == null ? new ParameterizedTypeBinding(unannotatedGenericType, (TypeBinding[])unannotatedTypeArguments, unannotatedEnclosingType, this.environment) : (genericType.isRole() ? new RoleTypeBinding(unannotatedGenericType, (TypeBinding[])unannotatedTypeArguments, teamAnchor, unannotatedEnclosingType, this.environment) : new DependentTypeBinding(unannotatedGenericType, (TypeBinding[])unannotatedTypeArguments, teamAnchor, valueParamPosition, unannotatedEnclosingType, this.environment));
        derivedTypes[i2] = parameterizedType;
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        parameterizedType.id = this.typeid++;
        ParameterizedTypeBinding parameterizedTypeBinding = parameterizedType;
        this.types[parameterizedType.id][0] = parameterizedTypeBinding;
        return parameterizedTypeBinding;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding genericType, TypeBinding[] typeArguments, ITeamAnchor teamAnchor, int valueParamPosition, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.getParameterizedType(genericType, typeArguments, teamAnchor, valueParamPosition, enclosingType);
    }

    public RawTypeBinding getRawType(ReferenceBinding genericType, ReferenceBinding enclosingType) {
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        ReferenceBinding unannotatedEnclosingType = enclosingType == null ? null : (ReferenceBinding)this.getUnannotatedType(enclosingType);
        TypeBinding[] derivedTypes = this.types[unannotatedGenericType.id];
        int length = derivedTypes.length;
        int i = 0;
        while (i < length) {
            TypeBinding derivedType = derivedTypes[i];
            if (derivedType == null) break;
            if (derivedType.isRawType() && derivedType.actualType() == unannotatedGenericType && !derivedType.hasTypeAnnotations() && derivedType.enclosingType() == unannotatedEnclosingType) {
                return (RawTypeBinding)derivedType;
            }
            ++i;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedGenericType.id] = derivedTypes;
        }
        derivedTypes[i] = new RawTypeBinding(unannotatedGenericType, unannotatedEnclosingType, this.environment);
        RawTypeBinding rawTytpe = derivedTypes[i];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        rawTytpe.id = this.typeid++;
        RawTypeBinding rawTypeBinding = rawTytpe;
        this.types[rawTytpe.id][0] = rawTypeBinding;
        return rawTypeBinding;
    }

    public RawTypeBinding getRawType(ReferenceBinding genericType, ReferenceBinding enclosingType, AnnotationBinding[] annotations) {
        return this.getRawType(genericType, enclosingType);
    }

    public WildcardBinding getWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind) {
        if (genericType == null) {
            genericType = ReferenceBinding.LUB_GENERIC;
        }
        ReferenceBinding unannotatedGenericType = (ReferenceBinding)this.getUnannotatedType(genericType);
        int otherBoundsLength = otherBounds == null ? 0 : otherBounds.length;
        Object[] unannotatedOtherBounds = otherBounds == null ? null : new TypeBinding[otherBoundsLength];
        int i = 0;
        while (i < otherBoundsLength) {
            unannotatedOtherBounds[i] = this.getUnannotatedType(otherBounds[i]);
            ++i;
        }
        TypeBinding unannotatedBound = bound == null ? null : this.getUnannotatedType(bound);
        TypeBinding[] derivedTypes = this.types[unannotatedGenericType.id];
        int length = derivedTypes.length;
        int i2 = 0;
        while (i2 < length) {
            TypeBinding derivedType = derivedTypes[i2];
            if (derivedType == null) break;
            if (derivedType.isWildcard() && derivedType.actualType() == unannotatedGenericType && !derivedType.hasTypeAnnotations() && derivedType.rank() == rank && derivedType.boundKind() == boundKind && derivedType.bound() == unannotatedBound && Util.effectivelyEqual(derivedType.additionalBounds(), unannotatedOtherBounds)) {
                return (WildcardBinding)derivedType;
            }
            ++i2;
        }
        if (i2 == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[unannotatedGenericType.id] = derivedTypes;
        }
        derivedTypes[i2] = new WildcardBinding(unannotatedGenericType, rank, unannotatedBound, (TypeBinding[])unannotatedOtherBounds, boundKind, this.environment);
        WildcardBinding wildcard = derivedTypes[i2];
        int typesLength = this.types.length;
        if (this.typeid == typesLength) {
            this.types = new TypeBinding[typesLength * 2][];
            System.arraycopy(this.types, 0, this.types, 0, typesLength);
        }
        this.types[this.typeid] = new TypeBinding[1];
        wildcard.id = this.typeid++;
        WildcardBinding wildcardBinding = wildcard;
        this.types[wildcard.id][0] = wildcardBinding;
        return wildcardBinding;
    }

    public WildcardBinding getWildcard(ReferenceBinding genericType, int rank, TypeBinding bound, TypeBinding[] otherBounds, int boundKind, AnnotationBinding[] annotations) {
        return this.getWildcard(genericType, rank, bound, otherBounds, boundKind);
    }

    public TypeBinding getAnnotatedType(TypeBinding type, AnnotationBinding[][] annotations) {
        return type;
    }

    protected final TypeBinding[] getDerivedTypes(TypeBinding keyType) {
        keyType = this.getUnannotatedType(keyType);
        return this.types[keyType.id];
    }

    private TypeBinding cacheDerivedType(TypeBinding keyType, TypeBinding derivedType) {
        if (keyType == null || derivedType == null || keyType.id == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        TypeBinding[] derivedTypes = this.types[keyType.id];
        int i = 0;
        int length = derivedTypes.length;
        while (i < length && derivedTypes[i] != null) {
            ++i;
        }
        if (i == length) {
            TypeBinding[] typeBindingArray = derivedTypes;
            derivedTypes = new TypeBinding[length * 2];
            System.arraycopy(typeBindingArray, 0, derivedTypes, 0, length);
            this.types[keyType.id] = derivedTypes;
        }
        derivedTypes[i] = derivedType;
        return derivedTypes[i];
    }

    protected final TypeBinding cacheDerivedType(TypeBinding keyType, TypeBinding nakedType, TypeBinding derivedType) {
        this.cacheDerivedType(keyType, derivedType);
        if (nakedType.id != keyType.id) {
            this.cacheDerivedType(nakedType, derivedType);
        }
        return derivedType;
    }

    public final AnnotationBinding getAnnotationType(ReferenceBinding annotationType, boolean requiredResolved) {
        AnnotationBinding annotation = (AnnotationBinding)this.annotationTypes.get(annotationType);
        if (annotation == null) {
            annotation = requiredResolved ? new AnnotationBinding(annotationType, Binding.NO_ELEMENT_VALUE_PAIRS) : new UnresolvedAnnotationBinding(annotationType, Binding.NO_ELEMENT_VALUE_PAIRS, this.environment);
            this.annotationTypes.put(annotationType, annotation);
        }
        if (requiredResolved) {
            annotation.resolve();
        }
        return annotation;
    }

    public boolean isAnnotatedTypeSystem() {
        return false;
    }

    public void reset() {
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
    }

    public void updateCaches(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType) {
        int unresolvedTypeId = unresolvedType.id;
        if (unresolvedTypeId != Integer.MAX_VALUE && this.types[unresolvedTypeId] != null && this.types[unresolvedTypeId][0] == unresolvedType) {
            resolvedType.id = unresolvedTypeId;
            this.types[unresolvedTypeId][0] = resolvedType;
        }
        if (this.annotationTypes.get(unresolvedType) != null) {
            Object[] keys = this.annotationTypes.keyTable;
            int i = 0;
            int l = keys.length;
            while (i < l) {
                if (keys[i] == unresolvedType) {
                    keys[i] = resolvedType;
                    break;
                }
                ++i;
            }
        }
    }

    public final TypeBinding getIntersectionCastType(ReferenceBinding[] intersectingTypes) {
        int intersectingTypesLength;
        int n = intersectingTypesLength = intersectingTypes == null ? 0 : intersectingTypes.length;
        if (intersectingTypesLength == 0) {
            return null;
        }
        ReferenceBinding keyType = intersectingTypes[0];
        if (keyType == null || intersectingTypesLength == 1) {
            return keyType;
        }
        TypeBinding[] derivedTypes = this.getDerivedTypes(keyType);
        int length = derivedTypes.length;
        int i = 0;
        while (i < length) {
            block6: {
                ReferenceBinding[] priorIntersectingTypes;
                TypeBinding derivedType = derivedTypes[i];
                if (derivedType == null) break;
                if (derivedType.isIntersectionCastType() && (priorIntersectingTypes = derivedType.getIntersectingTypes()).length == intersectingTypesLength) {
                    int j = 0;
                    while (j < intersectingTypesLength) {
                        if (intersectingTypes[j] == priorIntersectingTypes[j]) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return derivedType;
                }
            }
            ++i;
        }
        return this.cacheDerivedType(keyType, new IntersectionCastTypeBinding(intersectingTypes, this.environment));
    }

    boolean isRoleTypeMatch(ITeamAnchor teamAnchor, int valueParamPosition, TypeBinding cachedType) {
        if (teamAnchor != null) {
            if (!(cachedType instanceof DependentTypeBinding)) {
                return false;
            }
            if (!((DependentTypeBinding)cachedType)._teamAnchor.hasSameBestNameAs(teamAnchor)) {
                return false;
            }
        }
        if (valueParamPosition > -1 && !(cachedType instanceof DependentTypeBinding)) {
            return false;
        }
        if (cachedType instanceof DependentTypeBinding && ((DependentTypeBinding)cachedType)._valueParamPosition != valueParamPosition) {
            return false;
        }
        return teamAnchor != null || !cachedType.isRoleType();
    }
}

