/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticOTMethodBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class SyntheticRoleBridgeMethodBinding
extends SyntheticOTMethodBinding {
    public static final char[] PRIVATE = "$private$".toCharArray();

    public SyntheticRoleBridgeMethodBinding(SourceTypeBinding declaringRole, ReferenceBinding originalRole, MethodBinding targetMethod, int bridgeKind) {
        super(declaringRole, 4097, targetMethod.selector, SyntheticRoleBridgeMethodBinding.originalParameters(targetMethod), SyntheticRoleBridgeMethodBinding.originalReturnType(targetMethod));
        int methodId;
        this.purpose = bridgeKind;
        switch (bridgeKind) {
            case 19: {
                this.declaringClass = declaringRole.enclosingType();
                int len = this.parameters.length;
                if (len <= 0) break;
                this.parameters = new TypeBinding[len];
                System.arraycopy(this.parameters, 0, this.parameters, 0, len);
                this.parameters[0] = originalRole.getRealType();
                break;
            }
            case 20: {
                int len = this.parameters.length;
                int offset = targetMethod.isStatic() ? 2 : 0;
                TypeBinding[] newParameters = new TypeBinding[len + 1 + offset];
                newParameters[0] = originalRole.getRealType();
                if (offset > 0) {
                    newParameters[1] = TypeBinding.INT;
                    newParameters[2] = originalRole.enclosingType();
                }
                System.arraycopy(this.parameters, 0, newParameters, 1 + offset, len);
                this.parameters = newParameters;
                this.modifiers |= 8;
                this.selector = SyntheticRoleBridgeMethodBinding.getPrivateBridgeSelector(targetMethod.selector, declaringRole.sourceName());
            }
        }
        this.targetMethod = targetMethod;
        this.thrownExceptions = targetMethod.thrownExceptions;
        this.typeVariables = targetMethod.typeVariables;
        SyntheticMethodBinding[] knownAccessMethods = ((SourceTypeBinding)this.declaringClass).syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    private static TypeBinding[] originalParameters(MethodBinding targetMethod) {
        MethodBinding top;
        if (!TSuperHelper.isTSuper(targetMethod) && (top = SyntheticRoleBridgeMethodBinding.findTopMethod(targetMethod)) != null) {
            return top.original().parameters;
        }
        return targetMethod.original().parameters;
    }

    private static TypeBinding originalReturnType(MethodBinding targetMethod) {
        MethodBinding top;
        if (!TSuperHelper.isTSuper(targetMethod) && (top = SyntheticRoleBridgeMethodBinding.findTopMethod(targetMethod)) != null) {
            return top.original().returnType;
        }
        return targetMethod.original().returnType;
    }

    static MethodBinding findTopMethod(MethodBinding targetMethod) {
        block5: {
            while (targetMethod.copyInheritanceSrc != null) {
                targetMethod = targetMethod.copyInheritanceSrc;
            }
            if (targetMethod.overriddenTSupers != null) {
                int i = 0;
                while (i < targetMethod.overriddenTSupers.length) {
                    MethodBinding cand = targetMethod.overriddenTSupers[i];
                    if (!(cand instanceof ParameterizedMethodBinding)) {
                        targetMethod = cand;
                        break block5;
                    }
                    ++i;
                }
                if (targetMethod.overriddenTSupers.length > 0) {
                    targetMethod = targetMethod.overriddenTSupers[0];
                }
            }
        }
        return targetMethod;
    }

    @Override
    public void generateInstructions(CodeStream codeStream) {
        TypeBinding[] arguments = this.parameters;
        int argLen = arguments.length;
        TypeBinding[] targetParameters = this.targetMethod.parameters;
        int resolvedPosition = 0;
        int argIdx = 0;
        int targetIdx = 0;
        switch (this.purpose) {
            case 20: {
                codeStream.aload_0();
                codeStream.checkcast(this.targetMethod.declaringClass);
                resolvedPosition = 1;
                argIdx = 1;
                if (!this.targetMethod.isStatic()) break;
                codeStream.iconst_0();
                codeStream.aload_2();
                argIdx += 2;
                resolvedPosition += 2;
                break;
            }
            case 19: {
                resolvedPosition = 1;
                argIdx = 0;
            }
        }
        while (argIdx < argLen) {
            TypeBinding parameter = targetParameters[targetIdx++];
            TypeBinding argument = arguments[argIdx++];
            codeStream.load(argument, resolvedPosition);
            if (TypeBinding.notEquals(argument, parameter)) {
                codeStream.checkcast(parameter);
            }
            switch (parameter.id) {
                case 7: 
                case 8: {
                    resolvedPosition += 2;
                    break;
                }
                default: {
                    ++resolvedPosition;
                }
            }
        }
        if (this.targetMethod.isStatic()) {
            codeStream.invoke((byte)-72, this.targetMethod, null);
        } else {
            codeStream.invoke((byte)-73, this.targetMethod, null);
        }
        switch (this.targetMethod.returnType.id) {
            case 6: {
                codeStream.return_();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                codeStream.ireturn();
                break;
            }
            case 7: {
                codeStream.lreturn();
                break;
            }
            case 9: {
                codeStream.freturn();
                break;
            }
            case 8: {
                codeStream.dreturn();
                break;
            }
            default: {
                codeStream.areturn();
            }
        }
    }

    public static char[] getPrivateBridgeSelector(char[] selector, char[] roleName) {
        return CharOperation.concat(CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, roleName), CharOperation.concat(PRIVATE, selector));
    }

    public static boolean isPrivateBridgeSelector(char[] selector) {
        if (!CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, selector)) {
            return false;
        }
        return CharOperation.indexOf(PRIVATE, selector, true, IOTConstants.OT_DOLLAR_LEN) > -1;
    }

    public static MethodBinding findOuterAccessor(Scope scope, ReferenceBinding roleType, MethodBinding targetMethod) {
        ReferenceBinding roleClass = roleType.getRealClass();
        if (targetMethod.declaringClass.isSynthInterface()) {
            targetMethod = MethodModel.getClassPartMethod(targetMethod);
        }
        if (roleClass instanceof SourceTypeBinding) {
            return ((SourceTypeBinding)roleClass).findOuterRoleMethodSyntheticAccessor(targetMethod);
        }
        int len = targetMethod.parameters.length;
        TypeBinding[] extendedParamters = new TypeBinding[len + 1];
        extendedParamters[0] = roleType;
        System.arraycopy(targetMethod.parameters, 0, extendedParamters, 1, len);
        char[] selector = SyntheticRoleBridgeMethodBinding.getPrivateBridgeSelector(targetMethod.selector, roleType.sourceName());
        return TypeAnalyzer.findMethod(scope, roleType.enclosingType(), selector, extendedParamters);
    }
}

