/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.configmanager.internal;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.configmanager.IConfigurationFileHandler;
import org.ops4j.pax.configmanager.internal.ConfigAdminServiceTracker;
import org.ops4j.pax.configmanager.internal.ConfigurationAdminFacade;
import org.ops4j.pax.configmanager.internal.ConfigurationFileHandlerServiceTracker;
import org.ops4j.pax.configmanager.internal.handlers.PropertiesFileConfigurationHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class Activator
implements BundleActivator {
    private static final Log LOGGER = LogFactory.getLog(Activator.class);
    private static final String SERVICE_NAME = IConfigurationFileHandler.class.getName();
    private ServiceTracker m_configTracker;
    private ConfigurationFileHandlerServiceTracker m_configFileTracker;
    private ServiceRegistration m_registration;
    private ConfigurationAdminFacade m_configAdminFacade;

    public void start(final BundleContext context) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            Bundle contextBundle = context.getBundle();
            String symbolicName = contextBundle.getSymbolicName();
            LOGGER.debug("Starting [" + symbolicName + "]...");
        }
        PropertiesFileConfigurationHandler handler = new PropertiesFileConfigurationHandler();
        this.m_registration = context.registerService(SERVICE_NAME, (Object)handler, new Hashtable());
        this.m_configAdminFacade = new ConfigurationAdminFacade(new ConfigurationAdminFacade.PropertyResolver(){

            public String getProperty(String key) {
                return context.getProperty(key);
            }
        });
        this.m_configTracker = new ConfigAdminServiceTracker(context, this.m_configAdminFacade);
        this.m_configTracker.open();
        this.m_configFileTracker = new ConfigurationFileHandlerServiceTracker(context, this.m_configAdminFacade);
        this.m_configFileTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            Bundle contextBundle = context.getBundle();
            String symbolicName = contextBundle.getSymbolicName();
            LOGGER.debug("Stopping [" + symbolicName + "]");
        }
        this.m_registration.unregister();
        this.m_registration = null;
        this.m_configFileTracker.close();
        this.m_configFileTracker = null;
        this.m_configTracker.close();
        this.m_configTracker = null;
        this.m_configAdminFacade.dispose();
        this.m_configAdminFacade = null;
    }
}

