/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.ModuleClass;
import org.eclipse.om2m.sdt.utils.Activator;

public class Domain
extends Element {
    private Map<String, Domain> imports = new HashMap<String, Domain>();
    private Map<String, ModuleClass> modules = new HashMap<String, ModuleClass>();
    private Map<String, Device> devices = new HashMap<String, Device>();

    public Domain(String id) {
        super(id);
        Activator.addDomain(this);
    }

    public String getId() {
        return this.getName();
    }

    public Collection<String> getModuleNames() {
        return this.modules.keySet();
    }

    public Collection<ModuleClass> getModules() {
        return this.modules.values();
    }

    public ModuleClass getModule(String name) {
        return this.modules.get(name);
    }

    public void addModule(ModuleClass module) {
        if (this.modules.get(module.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.modules.put(module.getName(), module);
    }

    public void removeModule(String name) {
        this.modules.remove(name);
    }

    public Collection<String> getDeviceNames() {
        return this.devices.keySet();
    }

    public Collection<Device> getDevices() {
        return this.devices.values();
    }

    public Device getDevice(String name) {
        return this.devices.get(name);
    }

    public void addDevice(Device device) {
        if (this.devices.get(device.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.devices.put(device.getName(), device);
    }

    public void removeDevice(String name) {
        Device dev = this.devices.remove(name);
        if (dev != null) {
            for (Module mod : dev.getModules()) {
                this.removeModule(mod.getName());
            }
        }
    }

    public Collection<String> getImportNames() {
        return this.imports.keySet();
    }

    public Collection<Domain> getImports() {
        return this.imports.values();
    }

    public Domain getImport(String name) {
        return this.imports.get(name);
    }

    public void addImport(Domain domain) {
        if (this.imports.get(domain.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.imports.put(domain.getName(), domain);
    }

    public void removeImport(String name) {
        this.imports.remove(name);
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer("<Domain xmlns:xi=\"http://www.w3.org/2001/XInclude\" xmlns=\"http://homegatewayinitiative.org/xml/dal/3.0\" id=\"" + this.getId() + "\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        if (!this.imports.isEmpty()) {
            ret.append("<Imports>");
            for (Domain c : this.imports.values()) {
                ret.append("<xi:include href=\"" + c.getId() + ".xml\" parse=\"xml\"/>");
            }
            ret.append("</Imports>");
        }
        this.prettyPrint(ret, this.modules.values(), "Modules", t2);
        this.prettyPrint(ret, this.devices.values(), "Devices", t2);
        return ret.append("\n").append(t1).append("</Domain>").toString();
    }
}

