/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AbstractFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.AnnouncedResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class FlexContainerAnncMapper
extends EntityMapper<FlexContainerAnncEntity, AbstractFlexContainerAnnc> {
    @Override
    protected AbstractFlexContainerAnnc createResource() {
        return new AbstractFlexContainerAnnc();
    }

    @Override
    protected AbstractFlexContainerAnnc createResource(FlexContainerAnncEntity flexContainerAnncEntity) {
        return FlexContainerFactory.getSpecializationFlexContainerAnnc((String)flexContainerAnncEntity.getShortName());
    }

    @Override
    protected void mapAttributes(FlexContainerAnncEntity entity, AbstractFlexContainerAnnc resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnouncedResourceMapper().mapAttributes((AnnouncedResourceEntity)entity, (AnnouncedResource)resource, level, offset);
        resource.setCreator(entity.getCreator());
        resource.setOntologyRef(entity.getOntologyRef());
        resource.setStateTag(entity.getStateTag());
        resource.setContainerDefinition(entity.getContainerDefinition());
        resource.setNodeLink(entity.getNodeLink());
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(FlexContainerAnncEntity entity, int level, int offset) {
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (FlexContainerAnncEntity fcntAnnc : entity.getChildFlexContainerAnncs()) {
            child = new ChildResourceRef();
            child.setResourceName(fcntAnnc.getName());
            child.setType(10028);
            child.setValue(fcntAnnc.getResourceID());
            child.setSpid(fcntAnnc.getContainerDefinition());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerAnncMapper().getChildResourceRef(fcntAnnc, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(FlexContainerAnncEntity entity, AbstractFlexContainerAnnc resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(FlexContainerAnncEntity entity, AbstractFlexContainerAnnc resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (FlexContainerAnncEntity flexContainerAnncEntity : entity.getChildFlexContainerAnncs()) {
            AbstractFlexContainerAnnc flexContainerAnncRes = (AbstractFlexContainerAnnc)new FlexContainerAnncMapper().mapEntityToResource(flexContainerAnncEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getFlexContainerOrContainerOrSubscription().add(flexContainerAnncRes);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getFlexContainerOrContainerOrSubscription().add(subRes);
        }
        resource.finalizeSerialization();
    }
}

