/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;

public class CoreExecutor {
    private static final Log LOGGER = LogFactory.getLog((String)CoreExecutor.class.getName());
    private static final ExecutorService threadPool;

    static {
        int maximumPoolSize = Constants.MAX_THREAD_POOL_SIZE > 2 ? Constants.MAX_THREAD_POOL_SIZE : 2;
        int corePoolSize = maximumPoolSize / 10;
        LOGGER.info((Object)("Creating thread pool with corePoolSize=" + corePoolSize + " & maximumSize=" + maximumPoolSize));
        threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return threadPool.submit(callable);
    }

    public static void postThread(Runnable runnable) {
        threadPool.execute(runnable);
    }
}

