/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.CustomAttributeEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="FCNT")
@Inheritance(strategy=InheritanceType.JOINED)
public class FlexContainerEntity
extends AnnounceableSubordinateEntity {
    @Column(name="longName")
    protected String longName;
    @Column(name="shortName")
    protected String shortName;
    @Column(name="st")
    protected BigInteger stateTag;
    @Column(name="cr")
    protected String creator;
    @Column(name="or")
    protected String ontologyRef;
    @Column(name="cnd")
    protected String containerDefinition;
    @Column(name="nl")
    protected String nodeLink;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="FCNT_CA_JOIN", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CA_ID", referencedColumnName="ri")})
    protected List<CustomAttributeEntity> customAttributes;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="parentFlexCnt")
    @JoinTable(name="FCNT_SUB_JOIN", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="FCNT_ACP_JOIN", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedFlexContainerEntites")
    @JoinTable(name="FCNT_DAC_JOIN", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="FCNT_CHCNT", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CNTCH_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> childContainers;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentFlexContainer")
    @JoinTable(name="FCNT_CHFCNT", joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CFCNT_ID", referencedColumnName="ri")})
    protected List<FlexContainerEntity> childFlexContainers;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=FlexContainerEntity.class)
    @JoinTable(name="FCNT_CHFCNT", inverseJoinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CFCNT_ID", referencedColumnName="ri")})
    protected FlexContainerEntity parentFlexContainer;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=AeEntity.class)
    @JoinTable(name="AE_FCNT_JOIN", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")})
    protected AeEntity parentAE;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_FCNT_JOIN", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCSEB;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_CHFCNT_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCSR;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=ContainerEntity.class)
    @JoinTable(name="CNT_FCNTCHILD_JOIN", joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")})
    protected ContainerEntity parentContainer;

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public FlexContainerEntity getParentFlexContainer() {
        return this.parentFlexContainer;
    }

    public void setParentFlexContainer(FlexContainerEntity parentFlexContainer) {
        this.parentFlexContainer = parentFlexContainer;
    }

    public ContainerEntity getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(ContainerEntity parentContainer) {
        this.parentContainer = parentContainer;
    }

    public AeEntity getParentAE() {
        return this.parentAE;
    }

    public void setParentAE(AeEntity parentAE) {
        this.parentAE = parentAE;
    }

    public CSEBaseEntity getParentCSEB() {
        return this.parentCSEB;
    }

    public void setParentCSEB(CSEBaseEntity parentCSEB) {
        this.parentCSEB = parentCSEB;
    }

    public BigInteger getStateTag() {
        return this.stateTag;
    }

    public void setStateTag(BigInteger stateTag) {
        this.stateTag = stateTag;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getOntologyRef() {
        return this.ontologyRef;
    }

    public void setOntologyRef(String ontologyRef) {
        this.ontologyRef = ontologyRef;
    }

    public String getContainerDefinition() {
        return this.containerDefinition;
    }

    public void setContainerDefinition(String containerDefinition) {
        this.containerDefinition = containerDefinition;
    }

    public List<ContainerEntity> getChildContainers() {
        if (this.childContainers == null) {
            this.childContainers = new ArrayList<ContainerEntity>();
        }
        return this.childContainers;
    }

    public void setChildContainers(List<ContainerEntity> childContainers) {
        this.childContainers = childContainers;
    }

    public List<FlexContainerEntity> getChildFlexContainers() {
        if (this.childFlexContainers == null) {
            this.childFlexContainers = new ArrayList<FlexContainerEntity>();
        }
        return this.childFlexContainers;
    }

    public void setChildFlexContainers(List<FlexContainerEntity> childFlexContainers) {
        this.childFlexContainers = childFlexContainers;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    public CSEBaseEntity getParentCSR() {
        return this.parentCSR;
    }

    public void setParentCSR(CSEBaseEntity parentCSR) {
        this.parentCSR = parentCSR;
    }

    public String getNodeLink() {
        return this.nodeLink;
    }

    public void setNodeLink(String nodeLink) {
        this.nodeLink = nodeLink;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    public List<CustomAttributeEntity> getCustomAttributes() {
        if (this.customAttributes == null) {
            this.customAttributes = new ArrayList<CustomAttributeEntity>();
        }
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttributeEntity> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void createOrUpdateCustomAttribute(String name, Object value) {
        CustomAttributeEntity attToCreateOrUpdate = null;
        for (CustomAttributeEntity cae : this.getCustomAttributes()) {
            if (!cae.getCustomAttributeName().equals(name)) continue;
            attToCreateOrUpdate = cae;
            break;
        }
        if (attToCreateOrUpdate == null) {
            attToCreateOrUpdate = new CustomAttributeEntity();
            attToCreateOrUpdate.setCustomAttributeName(name);
            this.getCustomAttributes().add(attToCreateOrUpdate);
        }
        attToCreateOrUpdate.setCustomAttributeValue(value != null ? value.toString() : null);
    }
}

