/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.predicates.PredicatesFactory;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceProfileItemProvider
extends ModelElementItemProvider {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private Referents referents;

    public PreferenceProfileItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addReferentProjectsPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addReferentProjectsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceProfile_referentProjects_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceProfile_referentProjects_feature", "_UI_PreferenceProfile_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__REFERENT_PROJECTS, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection allProjects = super.getChoiceOfValues(object);
                PreferenceProfile preferenceProfile = (PreferenceProfile)object;
                EList predicates = preferenceProfile.getPredicates();
                if (predicates.isEmpty()) {
                    return allProjects;
                }
                ArrayList<Project> result = new ArrayList<Project>();
                for (Object value : allProjects) {
                    Project project = (Project)value;
                    String projectName = project.getPreferenceNode().getName();
                    IProject iProject = WORKSPACE_ROOT.getProject(projectName);
                    if (!preferenceProfile.matches(iProject)) continue;
                    result.add(project);
                }
                return result;
            }
        });
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceProfile_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceProfile_name_feature", "_UI_PreferenceProfile_type"), (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREFERENCE_FILTERS);
            this.childrenFeatures.add(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, false);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PreferenceProfile"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((PreferenceProfile)object).getName();
        return label == null ? "" : label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PreferenceProfile.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 1: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                if (this.referents != null) {
                    this.referents.update();
                }
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        Collection collection = commandParameter.getCollection();
        if (collection != null) {
            for (Object value : collection) {
                if (!(value instanceof Project)) continue;
                return this.referents.createCommand((Object)this.referents, domain, commandClass, commandParameter);
            }
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<Referents> result = new ArrayList<Referents>(super.getChildren(object));
        PreferenceProfile preferenceProfile = (PreferenceProfile)object;
        if (this.referents == null) {
            this.referents = new Referents(this.adapterFactory, "Referents", this.getResourceLocator().getImage("full/obj16/IncomingLinks"), preferenceProfile);
        }
        this.referents.update();
        result.add(this.referents);
        return result;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREFERENCE_FILTERS, ProjectConfigFactory.eINSTANCE.createPreferenceFilter()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, ProjectConfigFactory.eINSTANCE.createInclusionPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, ProjectConfigFactory.eINSTANCE.createExclusionPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createNamePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createCommentPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createLocationPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createRepositoryPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createAndPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createOrPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createNotPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createNaturePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createBuilderPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createFilePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectConfigPackage.Literals.PREFERENCE_PROFILE__PREDICATES, PredicatesFactory.eINSTANCE.createImportedPredicate()));
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigEditPlugin.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Referents
    extends ItemProvider
    implements IEditingDomainItemProvider {
        PreferenceProfile preferenceProfile;
        Map<Project, IWrapperItemProvider> wrappers;

        public Referents(AdapterFactory adapterFactory, String text, Object image, PreferenceProfile preferenceProfile) {
            super(adapterFactory, text, image, (Object)preferenceProfile);
            this.wrappers = new HashMap<Project, IWrapperItemProvider>();
            this.preferenceProfile = preferenceProfile;
        }

        public void update() {
            ArrayList<IWrapperItemProvider> children = new ArrayList<IWrapperItemProvider>();
            EList referentProjects = this.preferenceProfile.getReferentProjects();
            int i = 0;
            int size = referentProjects.size();
            while (i < size) {
                Project project = (Project)referentProjects.get(i);
                IWrapperItemProvider wrapper = this.wrap(i, project);
                children.add(wrapper);
                ++i;
            }
            ECollections.setEList((EList)this.getChildren(), children);
        }

        private IWrapperItemProvider wrap(int i, Project project) {
            Object wrapper = this.wrappers.get(project);
            if (wrapper == null) {
                wrapper = new DelegatingWrapperItemProvider(project, this.preferenceProfile, (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__REFERENT_PROJECTS, i, this.adapterFactory){

                    public Object getParent(Object object) {
                        return Referents.this;
                    }

                    public Object getImage(Object object) {
                        Object image = super.getImage(object);
                        ArrayList<Object> images = new ArrayList<Object>(2);
                        images.add(image);
                        images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/ControlledObject"));
                        image = new ComposedImage(images);
                        return image;
                    }

                    public boolean hasChildren(Object object) {
                        return false;
                    }

                    public Collection<?> getChildren(Object object) {
                        return Collections.emptyList();
                    }

                    public void notifyChanged(Notification notification) {
                        if (notification instanceof IViewerNotification && ((IViewerNotification)notification).isLabelUpdate()) {
                            super.notifyChanged(notification);
                        }
                    }
                };
                this.wrappers.put(project, (IWrapperItemProvider)wrapper);
            } else {
                wrapper.setIndex(i);
            }
            return wrapper;
        }

        public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
            final Collection originalCollection = commandParameter.getCollection();
            commandParameter = PreferenceProfileItemProvider.this.unwrapCommandValues(commandParameter, commandClass);
            Collection collection = commandParameter.getCollection();
            if (commandClass == RemoveCommand.class) {
                if (this.preferenceProfile.getReferentProjects().containsAll(collection)) {
                    return new RemoveCommand(editingDomain, (EObject)this.preferenceProfile, (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__REFERENT_PROJECTS, collection){

                        public void doExecute() {
                            super.doExecute();
                            Referents.this.update();
                            this.affectedObjects = Collections.singleton(Referents.this);
                        }

                        public void doUndo() {
                            super.doUndo();
                            Referents.this.update();
                            this.affectedObjects = Collections.singleton(Referents.this);
                        }

                        public void doRedo() {
                            super.doRedo();
                            Referents.this.update();
                            this.affectedObjects = Collections.singleton(Referents.this);
                        }
                    };
                }
            } else {
                if (commandClass == AddCommand.class && collection != null) {
                    final ArrayList<IWrapperItemProvider> wrappers = new ArrayList<IWrapperItemProvider>();
                    for (Object value : collection) {
                        if (value instanceof Project) {
                            wrappers.add(this.wrap(-1, (Project)value));
                            continue;
                        }
                        return UnexecutableCommand.INSTANCE;
                    }
                    return new AddCommand(editingDomain, (EObject)this.preferenceProfile, (EStructuralFeature)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__REFERENT_PROJECTS, collection){

                        public void doExecute() {
                            super.doExecute();
                            Referents.this.update();
                            this.affectedObjects = wrappers;
                        }

                        public void doUndo() {
                            super.doUndo();
                            Referents.this.update();
                            this.affectedObjects = Collections.singleton(Referents.this);
                        }

                        public void doRedo() {
                            super.doRedo();
                            Referents.this.update();
                            this.affectedObjects = wrappers;
                        }
                    };
                }
                if (commandClass == DragAndDropCommand.class) {
                    DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
                    return new DragAndDropCommand(editingDomain, this.preferenceProfile, detail.location, detail.operations, detail.operation, commandParameter.getCollection()){

                        protected boolean prepareDropLinkOn() {
                            this.dragCommand = IdentityCommand.INSTANCE;
                            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)((Object)Referents.this), (Object)ProjectConfigPackage.Literals.PREFERENCE_PROFILE__REFERENT_PROJECTS, (Collection)originalCollection);
                            return this.dropCommand.canExecute();
                        }
                    };
                }
            }
            return super.createCommand(object, editingDomain, commandClass, commandParameter);
        }
    }
}

