/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

public class RemoteDataProvider
implements DataProvider {
    private static final String USER_AGENT_ID = PropertiesUtil.getProperty((String)"oomph.setup.sync.user_agent_id", (String)"oomph/sync");
    private static final boolean DEBUG = PropertiesUtil.isProperty((String)"oomph.setup.sync.debug");
    private static final String BASE_VERSION_HEADER = "X-Base-Version";
    private static final String VERSION_HEADER = "X-Version";
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int AUTHORIZATION_REQUIRED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int CONFLICT = 409;
    private final URI uri;
    private final Executor executor;

    public RemoteDataProvider(URI serviceURI, Executor executor) {
        this.uri = serviceURI;
        this.executor = executor;
    }

    public RemoteDataProvider(URI serviceURI, Credentials credentials) {
        this(serviceURI, Executor.newInstance().auth(credentials));
    }

    public DataProvider.Location getLocation() {
        return DataProvider.Location.REMOTE;
    }

    public boolean update(File file) throws IOException, DataProvider.NotFoundException {
        HttpEntity responseEntity;
        block12: {
            block13: {
                int status;
                block10: {
                    block11: {
                        responseEntity = null;
                        String baseVersion = SyncUtil.getDigest(file);
                        Request request = this.configureRequest(Request.Get((URI)this.uri), baseVersion);
                        HttpResponse response = this.sendRequest(request);
                        responseEntity = response.getEntity();
                        status = this.getStatus(response);
                        if (status == 404) {
                            throw new DataProvider.NotFoundException(this.uri);
                        }
                        if (status != 304) break block10;
                        if (responseEntity == null) break block11;
                        EntityUtils.consume((HttpEntity)responseEntity);
                    }
                    return false;
                }
                if (status != 200) break block12;
                RemoteDataProvider.saveContent(responseEntity, file);
                if (responseEntity == null) break block13;
                EntityUtils.consume((HttpEntity)responseEntity);
            }
            return true;
        }
        try {
            try {
                throw new BadResponseException(this.uri);
            }
            catch (DataProvider.NotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (DEBUG && responseEntity != null) {
                    responseEntity.writeTo((OutputStream)System.out);
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (responseEntity != null) {
                EntityUtils.consume(responseEntity);
            }
            throw throwable;
        }
    }

    public void post(File file, String baseVersion) throws IOException, DataProvider.NotCurrentException {
        HttpEntity responseEntity = null;
        try {
            String version = SyncUtil.getDigest(file);
            HttpEntity requestEntity = MultipartEntityBuilder.create().addPart("userfile", (ContentBody)new FileBody(file)).build();
            Request request = this.configureRequest(Request.Post((URI)this.uri), baseVersion).addHeader(VERSION_HEADER, version).body(requestEntity);
            HttpResponse response = this.sendRequest(request);
            responseEntity = response.getEntity();
            int status = this.getStatus(response);
            if (status == 409) {
                RemoteDataProvider.saveContent(responseEntity, file);
                throw new DataProvider.NotCurrentException(this.uri);
            }
            if (status == 200) {
                return;
            }
            throw new BadResponseException(this.uri);
        }
        catch (IOException ex) {
            if (DEBUG && responseEntity != null) {
                responseEntity.writeTo((OutputStream)System.out);
            }
            throw ex;
        }
    }

    public boolean delete() throws IOException {
        Request request = this.configureRequest(Request.Delete((URI)this.uri), null);
        HttpResponse response = this.sendRequest(request);
        int status = this.getStatus(response);
        return status != 404;
    }

    private Request configureRequest(Request request, String baseVersion) {
        return request.viaProxy(SyncUtil.getProxyHost(this.uri)).connectTimeout(3000).staleConnectionCheck(true).socketTimeout(10000).addHeader(BASE_VERSION_HEADER, StringUtil.safe((String)baseVersion)).addHeader("User-Agent", USER_AGENT_ID);
    }

    private HttpResponse sendRequest(Request request) throws IOException {
        Response result = SyncUtil.proxyAuthentication(this.executor, this.uri).execute(request);
        HttpResponse response = result.returnResponse();
        if (DEBUG) {
            System.out.println(response.getStatusLine());
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                System.out.println("   " + header);
                ++n2;
            }
        }
        return response;
    }

    private int getStatus(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new BadResponseException(this.uri);
        }
        int status = statusLine.getStatusCode();
        if (status == 400) {
            throw new BadRequestException(this.uri);
        }
        if (status == 403) {
            throw new ForbiddenException(this.uri);
        }
        if (status == 401) {
            throw new AuthorizationRequiredException(this.uri);
        }
        return status;
    }

    private static void saveContent(HttpEntity entity, File file) throws IOException {
        file.getParentFile().mkdirs();
        InputStream content = null;
        BufferedOutputStream out = null;
        try {
            content = entity.getContent();
            out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtil.copy((InputStream)content, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            IOUtil.closeSilent((Closeable)content);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)out);
        IOUtil.closeSilent((Closeable)content);
    }

    public static class AuthorizationRequiredException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AuthorizationRequiredException(URI uri) {
            super("Forbidden: " + uri);
        }
    }

    public static class BadRequestException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public BadRequestException(URI uri) {
            super("Bad request: " + uri);
        }
    }

    public static class BadResponseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public BadResponseException(URI uri) {
            super("Bad response: " + uri);
        }
    }

    public static class ForbiddenException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ForbiddenException(URI uri) {
            super("Forbidden: " + uri);
        }
    }
}

