/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.engine.phases.AuthorityChecker;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.osgi.service.prefs.BackingStoreException;

public final class P2Util {
    public static final String X509_CERTIFICATE_FILE_EXTENSION = ".der";
    public static final String X509_CERTIFICATE_PEM_FILE_EXTENSION = ".pem";
    public static final String PGP_KEY_FILE_EXTENSION = ".asc";
    private static final String PREFERENCES_FILE_NAME = "preferences.properties";
    private static final Pattern OSGI_PROPERTY_FILTER = Pattern.compile("(!?)\\((osgi.arch|osgi.os|osgi.ws)=([^)]+)\\)");

    private P2Util() {
    }

    public static synchronized AgentManager getAgentManager() {
        if (AgentManagerImpl.instance == null) {
            AgentManagerImpl.instance = new AgentManagerImpl();
        }
        return AgentManagerImpl.instance;
    }

    public static File getAgentLocation(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        return URIUtil.toFile((URI)location.getRootLocation());
    }

    public static IProvisioningAgent getCurrentProvisioningAgent() {
        return P2Util.getAgentManager().getCurrentAgent().getProvisioningAgent();
    }

    public static Agent createAgent(File agentLocation) {
        return new AgentImpl((AgentManagerImpl)P2Util.getAgentManager(), agentLocation);
    }

    public static Set<String> getKnownRepositories(IRepositoryManager<?> manager) {
        HashSet<String> result = new HashSet<String>();
        URI[] uRIArray = manager.getKnownRepositories(2);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            result.add(uri.toString());
            ++n2;
        }
        return result;
    }

    public static File getCacheFile(URI uri) {
        CachingTransport transport;
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
        if (manager instanceof CachingRepositoryManager && (transport = ((CachingRepositoryManager)manager).getTransport()) != null) {
            return transport.getCacheFile(uri);
        }
        return null;
    }

    public static void copyTrustPreferences(Profile sourceProfile, Profile targetProfile) {
        if (sourceProfile != null && targetProfile != null) {
            IEclipsePreferences source = P2Util.getTrustPreferences(sourceProfile);
            IEclipsePreferences target = P2Util.getTrustPreferences(targetProfile);
            try {
                String[] stringArray = source.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    target.put(key, source.get(key, null));
                    ++n2;
                }
                target.flush();
            }
            catch (BackingStoreException ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
        }
    }

    public static IEclipsePreferences getTrustPreferences(Profile profile) {
        return new ProfileScope((IAgentLocation)profile.getProvisioningAgent().getService(IAgentLocation.class), profile.getProfileId()).getNode("org.eclipse.equinox.p2.engine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeGlobalTrustPreferences(Profile profile) {
        Profile profile2 = profile;
        synchronized (profile2) {
            CertificateChecker currentCertificateChecker = P2Util.createCertificateCheker(profile);
            File globalTrustFolder = P2Util.getGlobalTrustFolder();
            boolean trustAlways = "true".equals(PropertiesUtil.getProperties((File)new File(globalTrustFolder, PREFERENCES_FILE_NAME)).getOrDefault("trustAlways", "false"));
            CertificateFactory certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
            PGPPublicKeyStore trustedKeys = new PGPPublicKeyStore();
            LinkedHashSet<? extends Certificate> trustedCertificates = new LinkedHashSet<Certificate>();
            File[] fileArray = globalTrustFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (name.endsWith(PGP_KEY_FILE_EXTENSION)) {
                    trustedKeys.add(file);
                } else if (certificateFactory != null && name.endsWith(X509_CERTIFICATE_FILE_EXTENSION)) {
                    try {
                        Throwable throwable = null;
                        Object var14_18 = null;
                        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(input);
                            trustedCertificates.addAll(certificates);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        P2CorePlugin.INSTANCE.log(ex);
                    }
                }
                ++n2;
            }
            trustedCertificates.addAll(currentCertificateChecker.getPreferenceTrustedCertificates());
            for (PGPPublicKey key : currentCertificateChecker.getPreferenceTrustedKeys().all()) {
                trustedKeys.addKey(key);
            }
            currentCertificateChecker.setTrustAlways(trustAlways);
            currentCertificateChecker.persistTrustedCertificates(trustedCertificates);
            currentCertificateChecker.persistTrustedKeys(trustedKeys);
            if (TrustAuthoritySupport.ENABLED) {
                TrustAuthoritySupport.mergeGlobalTrustPreferences(profile, globalTrustFolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addedTrustedKeys(Profile profile, Collection<? extends PGPPublicKey> keys) {
        Profile profile2 = profile;
        synchronized (profile2) {
            CertificateChecker currentCertificateChecker = P2Util.createCertificateCheker(profile);
            PGPPublicKeyStore preferenceTrustedKeys = currentCertificateChecker.getPreferenceTrustedKeys();
            keys.forEach(arg_0 -> ((PGPPublicKeyStore)preferenceTrustedKeys).addKey(arg_0));
            currentCertificateChecker.persistTrustedKeys(preferenceTrustedKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addedTrustedCertificates(Profile profile, Collection<? extends Certificate> certificates) {
        Profile profile2 = profile;
        synchronized (profile2) {
            CertificateChecker currentCertificateChecker = P2Util.createCertificateCheker(profile);
            LinkedHashSet<? extends Certificate> preferenceTrustedCertificates = new LinkedHashSet<Certificate>(currentCertificateChecker.getPreferenceTrustedCertificates());
            preferenceTrustedCertificates.addAll(certificates);
            currentCertificateChecker.persistTrustedCertificates(preferenceTrustedCertificates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGlobalTrustPreferences(Profile profile, boolean strict) {
        Profile profile2 = profile;
        synchronized (profile2) {
            Throwable throwable;
            Serializable certificateFile;
            CertificateChecker certificateChecker = P2Util.createCertificateCheker(profile);
            boolean trustAlways = certificateChecker.isTrustAlways();
            Set trustedCertificates = certificateChecker.getPreferenceTrustedCertificates();
            PGPPublicKeyStore trustedKeys = certificateChecker.getPreferenceTrustedKeys();
            File trustFolder = P2Util.getGlobalTrustFolder();
            File propertiesFile = new File(trustFolder, PREFERENCES_FILE_NAME);
            Map properties = PropertiesUtil.getProperties((File)propertiesFile);
            properties.put("trustAlways", Boolean.toString(trustAlways));
            PropertiesUtil.saveProperties((File)propertiesFile, (Map)properties, (boolean)false);
            LinkedHashSet<File> retainedFiles = new LinkedHashSet<File>();
            for (Certificate certificate : trustedCertificates) {
                try {
                    byte[] encoded = certificate.getEncoded();
                    certificateFile = new File(trustFolder, PGPPublicKeyService.toHex((byte[])IOUtil.getSHA1((InputStream)new ByteArrayInputStream(encoded))) + X509_CERTIFICATE_FILE_EXTENSION);
                    retainedFiles.add((File)certificateFile);
                    if (((File)certificateFile).isFile()) continue;
                    throwable = null;
                    Object var16_23 = null;
                    try (OutputStream output = Files.newOutputStream(((File)certificateFile).toPath(), new OpenOption[0]);){
                        output.write(encoded);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    P2CorePlugin.INSTANCE.log(ex);
                }
            }
            for (PGPPublicKey key : trustedKeys.all()) {
                File keyFile = new File(trustFolder, PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key) + PGP_KEY_FILE_EXTENSION);
                retainedFiles.add(keyFile);
                if (keyFile.isFile()) continue;
                try {
                    certificateFile = null;
                    throwable = null;
                    try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new FileOutputStream(keyFile));){
                        key.encode((OutputStream)output);
                    }
                    catch (Throwable throwable3) {
                        if (certificateFile == null) {
                            certificateFile = throwable3;
                        } else if (certificateFile != throwable3) {
                            ((Throwable)certificateFile).addSuppressed(throwable3);
                        }
                        throw certificateFile;
                    }
                }
                catch (Exception ex) {
                    P2CorePlugin.INSTANCE.log(ex);
                }
            }
            if (strict) {
                File[] fileArray = trustFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    File file = fileArray[n2];
                    if (!retainedFiles.contains(file) && ((name = file.getName()).endsWith(PGP_KEY_FILE_EXTENSION) || name.endsWith(X509_CERTIFICATE_FILE_EXTENSION))) {
                        IOUtil.deleteBestEffort((File)file, (boolean)false);
                    }
                    ++n2;
                }
            }
            if (TrustAuthoritySupport.ENABLED) {
                TrustAuthoritySupport.saveGlobalTrustPreferences(profile, trustFolder, strict);
            }
        }
    }

    public static <T> Iterable<T> asIterable(final IQueryResult<T> queryResult) {
        if (queryResult instanceof Iterable) {
            return (Iterable)Iterable.class.cast(queryResult);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return queryResult.iterator();
            }
        };
    }

    public static boolean isSimpleRequiredCapability(IRequirement requirement) {
        return requirement instanceof IRequiredCapability;
    }

    public static Runnable preserveBundlePoolTimestamps(File bundlePoolLocation) {
        final File featuresFolder = new File(bundlePoolLocation, "features");
        final long featuresFolderLastModified = featuresFolder.lastModified();
        final File pluginsFolder = new File(bundlePoolLocation, "plugins");
        final long pluginsFolderLastModified = pluginsFolder.lastModified();
        return new Runnable(){

            @Override
            public void run() {
                if (featuresFolderLastModified != 0L) {
                    featuresFolder.setLastModified(featuresFolderLastModified);
                }
                if (pluginsFolderLastModified != 0L) {
                    pluginsFolder.setLastModified(pluginsFolderLastModified);
                }
            }
        };
    }

    public static String getName(IInstallableUnit iu) {
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (StringUtil.isEmpty((String)name)) {
            return iu.getId();
        }
        return name;
    }

    public static Map<String, String> toProfilePropertiesMap(String profileProperties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!StringUtil.isEmpty((String)profileProperties)) {
            String[] properties;
            String[] stringArray = properties = profileProperties.split(",");
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int index = property.indexOf(61);
                if (index == -1) {
                    result.put(property, null);
                } else {
                    result.put(property.substring(0, index), property.substring(index + 1));
                }
                ++n2;
            }
        }
        return result;
    }

    public static String toProfilePropertiesString(Map<String, String> profileProperties) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : profileProperties.entrySet()) {
            if (result.length() != 0) {
                result.append(",");
            }
            String key = entry.getKey();
            result.append(key);
            String value = entry.getValue();
            if (value == null) continue;
            result.append(' ').append(value);
        }
        return result.toString();
    }

    public static IInstallableUnit createGeneralizedIU(IInstallableUnit iu, boolean isIncludeAllPlatforms, boolean isIncludeAllRequirements, boolean isIncludeNegativeRequirements) {
        MetadataFactory.InstallableUnitDescription description;
        if (!isIncludeAllPlatforms && isIncludeAllRequirements && isIncludeNegativeRequirements) {
            return iu;
        }
        IMatchExpression<IInstallableUnit> filter = iu.getFilter();
        IMatchExpression<IInstallableUnit> generalizedFilter = isIncludeAllPlatforms ? P2Util.generalize(filter) : filter;
        boolean needsGeneralization = filter != generalizedFilter;
        Collection requirements = iu.getRequirements();
        IRequirement[] generalizedRequirements = requirements.toArray(new IRequirement[requirements.size()]);
        int i = 0;
        while (i < generalizedRequirements.length) {
            IRequirement requirement = generalizedRequirements[i];
            IMatchExpression<IInstallableUnit> requirementFilter = requirement.getFilter();
            IMatchExpression<IInstallableUnit> generalizedRequirementFilter = isIncludeAllPlatforms ? P2Util.generalize(requirementFilter) : requirementFilter;
            int max = requirement.getMax();
            int min = requirement.getMin();
            if (requirementFilter != generalizedRequirementFilter || !isIncludeAllRequirements && min != 0 || !isIncludeNegativeRequirements && max == 0) {
                IRequirement generalizedRequirement;
                needsGeneralization = true;
                generalizedRequirements[i] = generalizedRequirement = MetadataFactory.createRequirement((IMatchExpression)requirement.getMatches(), generalizedRequirementFilter, (int)(requirementFilter != generalizedRequirementFilter || !isIncludeAllRequirements ? 0 : min), (int)(!isIncludeNegativeRequirements && max == 0 ? Integer.MAX_VALUE : max), (boolean)true, (String)requirement.getDescription());
            }
            ++i;
        }
        if (!needsGeneralization) {
            return iu;
        }
        if (iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment installableUnitFragment = (IInstallableUnitFragment)iu;
            MetadataFactory.InstallableUnitFragmentDescription fragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
            Collection host = installableUnitFragment.getHost();
            fragmentDescription.setHost(host.toArray(new IRequirement[host.size()]));
            description = fragmentDescription;
        } else if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch installableUnitPatch = (IInstallableUnitPatch)iu;
            MetadataFactory.InstallableUnitPatchDescription patchDescription = new MetadataFactory.InstallableUnitPatchDescription();
            patchDescription.setApplicabilityScope(installableUnitPatch.getApplicabilityScope());
            patchDescription.setLifeCycle(installableUnitPatch.getLifeCycle());
            List requirementsChange = installableUnitPatch.getRequirementsChange();
            patchDescription.setRequirementChanges(requirementsChange.toArray(new IRequirementChange[requirementsChange.size()]));
            description = patchDescription;
        } else {
            description = new MetadataFactory.InstallableUnitDescription();
        }
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        description.setFilter(generalizedFilter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        description.setRequirements(generalizedRequirements);
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    private static IMatchExpression<IInstallableUnit> generalize(IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return null;
        }
        Object[] generalizedParameters = null;
        Object[] parameters = filter.getParameters();
        int i = 0;
        while (i < parameters.length) {
            String value;
            Matcher matcher;
            Object parameter = parameters[i];
            if (parameter instanceof LDAPFilter && (matcher = OSGI_PROPERTY_FILTER.matcher(value = parameter.toString())).find()) {
                if (generalizedParameters == null) {
                    generalizedParameters = new Object[parameters.length];
                    System.arraycopy(parameters, 0, generalizedParameters, 0, parameters.length);
                }
                StringBuffer result = new StringBuffer();
                if (matcher.group(1).length() == 0) {
                    matcher.appendReplacement(result, "($2=*)");
                } else {
                    matcher.appendReplacement(result, "!($2=nothing)");
                }
                while (matcher.find()) {
                    if (matcher.group(1).length() == 0) {
                        matcher.appendReplacement(result, "($2=*)");
                        continue;
                    }
                    matcher.appendReplacement(result, "!($2=nothing)");
                }
                matcher.appendTail(result);
                IFilterExpression ldap = ExpressionUtil.parseLDAP((String)result.toString());
                generalizedParameters[i] = ldap;
            }
            ++i;
        }
        if (generalizedParameters != null) {
            IExpression expression = ExpressionUtil.parse((String)filter.toString());
            return ExpressionUtil.getFactory().matchExpression(expression, generalizedParameters);
        }
        return filter;
    }

    private static MetadataFactory.InstallableUnitDescription createDescription(IInstallableUnit iu) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        IMatchExpression filter = iu.getFilter();
        description.setFilter(filter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        Collection requirements = iu.getRequirements();
        description.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return description;
    }

    private static CertificateChecker createCertificateCheker(Profile profile) {
        CertificateChecker certificateChecker = new CertificateChecker(profile.getProvisioningAgent());
        certificateChecker.setProfile((IProfile)profile);
        return certificateChecker;
    }

    private static File getGlobalTrustFolder() {
        File folder = P2CorePlugin.getUserStateFolder(new File(PropertiesUtil.getUserHome()));
        File trustFolder = new File(folder, "trust");
        trustFolder.mkdirs();
        return trustFolder;
    }

    public static IInstallableUnit createJREIU(String id) {
        IInstallableUnit jreIU = JREAction.createJREIU();
        Runtime.Version version = Runtime.version();
        Version jreIUVersion = Version.createOSGi((int)version.feature(), (int)version.interim(), (int)version.update());
        MetadataFactory.InstallableUnitDescription installableUnitDescription = new MetadataFactory.InstallableUnitDescription();
        installableUnitDescription.setId(id);
        ArrayList<Object> providedCapabilities = new ArrayList<Object>();
        for (IProvidedCapability providedCapability : jreIU.getProvidedCapabilities()) {
            String namespace = providedCapability.getNamespace();
            if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(providedCapability.getProperties());
                properties.put("version", jreIUVersion);
                properties.put("org.eclipse.equinox.p2.iu", id);
                providedCapabilities.add(new ProvidedCapability(namespace, properties));
                continue;
            }
            providedCapabilities.add(providedCapability);
        }
        installableUnitDescription.setCapabilities((IProvidedCapability[])providedCapabilities.toArray(IProvidedCapability[]::new));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)installableUnitDescription);
    }

    private static class TrustAuthoritySupport {
        public static final boolean ENABLED;

        static {
            boolean enabled = false;
            try {
                AuthorityChecker.class.getName();
                enabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ENABLED = enabled;
        }

        private TrustAuthoritySupport() {
        }

        public static AuthorityChecker createAuthorityChecker(Profile profile) {
            AuthorityChecker authorityChecker = new AuthorityChecker(profile.getProvisioningAgent(), (IProfile)profile);
            return authorityChecker;
        }

        public static void mergeGlobalTrustPreferences(Profile profile, File globalTrustFolder) {
            AuthorityChecker authorityChecker = TrustAuthoritySupport.createAuthorityChecker(profile);
            Map properties = PropertiesUtil.getProperties((File)new File(globalTrustFolder, P2Util.PREFERENCES_FILE_NAME));
            boolean trustAllAuthorities = "true".equals(properties.getOrDefault("trustAllAuthorities", "false"));
            List<String> trustedAuthoritiesProperty = Arrays.asList(properties.getOrDefault("trustedAuthorities", "").split("\\s+"));
            LinkedHashSet<URI> trustedAuthorities = new LinkedHashSet<URI>(authorityChecker.getPreferenceTrustedAuthorities());
            for (String authority : trustedAuthoritiesProperty) {
                try {
                    if (authority.isBlank()) continue;
                    trustedAuthorities.add(new URI(authority));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            authorityChecker.setTrustAlways(trustAllAuthorities);
            authorityChecker.persistTrustedAuthorities(trustedAuthorities);
        }

        public static void saveGlobalTrustPreferences(Profile profile, File trustFolder, boolean strict) {
            AuthorityChecker authorityChecker = TrustAuthoritySupport.createAuthorityChecker(profile);
            boolean trustAlways = authorityChecker.isTrustAlways();
            Set trustedAuthorities = authorityChecker.getPreferenceTrustedAuthorities();
            File propertiesFile = new File(trustFolder, P2Util.PREFERENCES_FILE_NAME);
            Map properties = PropertiesUtil.getProperties((File)propertiesFile);
            LinkedHashSet<String> trustedAuthoritiesProperty = new LinkedHashSet<String>();
            if (!strict) {
                trustedAuthoritiesProperty.addAll(Arrays.asList(properties.getOrDefault("trustedAuthorities", "").split("\\s+")));
                trustedAuthoritiesProperty.remove("");
            }
            for (URI uri : trustedAuthorities) {
                trustedAuthoritiesProperty.add(uri.toString());
            }
            properties.put("trustAllAuthorities", Boolean.toString(trustAlways));
            properties.put("trustedAuthorities", String.join((CharSequence)" ", trustedAuthoritiesProperty));
            PropertiesUtil.saveProperties((File)propertiesFile, (Map)properties, (boolean)false);
        }
    }

    public static interface VersionedIdFilter {
        public boolean matches(IVersionedId var1);
    }
}

