/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.freebsd.FreeBsdBaseboard;
import oshi.hardware.platform.unix.freebsd.FreeBsdFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

final class FreeBsdComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    FreeBsdComputerSystem() {
        this.init();
    }

    private void init() {
        String manufacturer = "";
        String manufacturerMarker = "Manufacturer:";
        String productName = "";
        String productNameMarker = "Product Name:";
        String serialNumber = "";
        String serialNumMarker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            if (checkLine.contains("Manufacturer:")) {
                manufacturer = checkLine.split("Manufacturer:")[1].trim();
            }
            if (checkLine.contains("Product Name:")) {
                productName = checkLine.split("Product Name:")[1].trim();
            }
            if (!checkLine.contains("Serial Number:")) continue;
            serialNumber = checkLine.split("Serial Number:")[1].trim();
        }
        if (!manufacturer.isEmpty()) {
            this.setManufacturer(manufacturer);
        }
        if (!productName.isEmpty()) {
            this.setModel(productName);
        }
        if (serialNumber.isEmpty()) {
            serialNumber = this.getSystemSerialNumber();
        }
        this.setSerialNumber(serialNumber);
        this.setFirmware(new FreeBsdFirmware());
        this.setBaseboard(new FreeBsdBaseboard());
    }

    private String getSystemSerialNumber() {
        String marker = "system.hardware.serial =";
        for (String checkLine : ExecutingCommand.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return ParseUtil.getSingleQuoteStringValue(checkLine);
        }
        return "unknown";
    }
}

